% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_folder.R
\name{read_folder}
\alias{read_folder}
\title{Reads all files present in a folder and creates a list with the content of these files}
\usage{
read_folder(folder = try(file.choose(), silent = TRUE), wildcard = "*.*",
  read = read.delim, ...)
}
\arguments{
\item{folder}{Where to search for files; can be or a file path or a folder path}

\item{wildcard}{Define which files are to be read (examples: "*.*", "*.xls", "essai*.txt")}

\item{read}{Function used to read file. Ex: read.delim or read.xls from gdata package}

\item{...}{Parameters send to the read function}
}
\value{
Return a list of the data in the files of the folder (directory for windows users)
}
\description{
To create a list, the syntax is:\cr
datalist<-read.folder(folder=".", read=read.delim, header=FALSE)\cr
It returns NULL with a warning if the folder does not exist or is empty.\cr
The names of the elements of the list are the filenames.\cr
}
\details{
read.folder reads all files present in a folder
}
\examples{
\dontrun{
library(HelpersMG)
# Read all the files from a folder/directory
Gratiot<-read.folder(folder=".", wildcard="*.csv", read=read.csv2)
}
}
\author{
Marc Girondot
}

