/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot.plotml;

import com.microstar.xml.XmlException;
import java.awt.Color;
import ptolemy.plot.Plot;
import ptolemy.plot.plotml.PlotBoxMLParser;

public class PlotMLParser
extends PlotBoxMLParser {
    protected boolean _connected = true;
    protected int _currentDataset = -1;
    protected double _currentPointCount = 0.0;

    public PlotMLParser(Plot plot) {
        super(plot);
    }

    protected PlotMLParser() {
    }

    public void endElement(String string) throws Exception {
        super.endElement(string);
        if (string.equals("dataset")) {
            ((Plot)this._plot).setConnected(this._connected);
        }
    }

    public void startDocument() {
        super.startDocument();
        this._currentDataset = -1;
        this._currentPointCount = 0.0;
    }

    public void startElement(String string) throws XmlException {
        try {
            if (string.equals("barGraph")) {
                String string2 = (String)this._attributes.get("width");
                String string3 = (String)this._attributes.get("offset");
                if (string2 == null || string3 == null) {
                    ((Plot)this._plot).setBars(true);
                } else {
                    double d = Double.valueOf(string2);
                    double d2 = Double.valueOf(string3);
                    ((Plot)this._plot).setBars(d, d2);
                }
            } else if (string.equals("dataset")) {
                String string4;
                String string5;
                String string6;
                String string7;
                String string8 = (String)this._attributes.get("name");
                if (!((Plot)this._plot).getReuseDatasets() || string8 == null || this._currentDataset < 0) {
                    ++this._currentDataset;
                    this._currentPointCount = 0.0;
                } else {
                    int n = ((Plot)this._plot).getLegendDataset(string8);
                    if (n != -1) {
                        this._currentDataset = n;
                    } else {
                        ++this._currentDataset;
                        this._currentPointCount = 0.0;
                    }
                }
                if (string8 != null) {
                    ((Plot)this._plot).addLegend(this._currentDataset, string8);
                }
                if ((string7 = (String)this._attributes.get("connected")) != null) {
                    if (string7.equals("no")) {
                        ((Plot)this._plot).setConnected(false, this._currentDataset);
                    } else {
                        ((Plot)this._plot).setConnected(true, this._currentDataset);
                    }
                }
                if ((string6 = (String)this._attributes.get("marks")) != null) {
                    ((Plot)this._plot).setMarksStyle(string6, this._currentDataset);
                }
                if ((string5 = (String)this._attributes.get("stems")) != null) {
                    if (string5.equals("yes")) {
                        ((Plot)this._plot).setImpulses(true, this._currentDataset);
                    } else {
                        ((Plot)this._plot).setImpulses(false, this._currentDataset);
                    }
                }
                if ((string4 = (String)this._attributes.get("color")) != null) {
                    ((Plot)this._plot).setColor(new Color(Integer.valueOf(String.valueOf(string4), 16)), this._currentDataset);
                }
            } else if (string.equals("default")) {
                String string9;
                String string10 = (String)this._attributes.get("connected");
                if (string10.equals("yes")) {
                    ((Plot)this._plot).setConnected(true);
                    this._connected = true;
                } else {
                    ((Plot)this._plot).setConnected(false);
                    this._connected = false;
                }
                String string11 = (String)this._attributes.get("marks");
                if (string11 != null) {
                    ((Plot)this._plot).setMarksStyle(string11);
                }
                if ((string9 = (String)this._attributes.get("stems")).equals("no")) {
                    ((Plot)this._plot).setImpulses(false);
                } else {
                    ((Plot)this._plot).setImpulses(true);
                }
            } else if (string.equals("m")) {
                this._addPoint(false, string);
            } else if (string.equals("move")) {
                this._addPoint(false, string);
            } else if (string.equals("p")) {
                this._addPoint(true, string);
            } else if (string.equals("point")) {
                this._addPoint(true, string);
            } else if (string.equals("reuseDatasets")) {
                ((Plot)this._plot).setReuseDatasets(true);
            } else {
                super.startElement(string);
            }
        }
        catch (Exception exception) {
            if (exception instanceof XmlException) {
                throw (XmlException)exception;
            }
            System.err.println(exception.toString());
            exception.printStackTrace();
            String string12 = "XML element \"" + string + "\" triggers exception:\n  " + exception.toString();
            throw new XmlException(string12, this._currentExternalEntity(), this._parser.getLineNumber(), this._parser.getColumnNumber());
        }
        this._attributes.clear();
    }

    protected void _addPoint(boolean bl, String string) throws Exception {
        double d;
        String string2 = (String)this._attributes.get("x");
        if (string2 == null) {
            d = this._currentPointCount;
            this._currentPointCount += 1.0;
        } else {
            d = Double.valueOf(string2);
        }
        String string3 = (String)this._attributes.get("y");
        this._checkForNull(string3, "No y value for element \"" + string + "\"");
        double d2 = Double.valueOf(string3);
        String string4 = (String)this._attributes.get("color");
        Color color = string4 == null ? null : new Color(Integer.valueOf(String.valueOf(string4), 16));
        String string5 = (String)this._attributes.get("diameter");
        int n = string5 == null ? 6 : (int)Double.valueOf(string5).doubleValue();
        String string6 = (String)this._attributes.get("label");
        String string7 = (String)this._attributes.get("lowErrorBar");
        String string8 = (String)this._attributes.get("highErrorBar");
        if (string7 == null && string8 == null) {
            ((Plot)this._plot).addPoint(this._currentDataset, d, d2, string6, color, n, bl);
        } else {
            double d3 = string7 != null ? Double.valueOf(string7) : d;
            double d4 = string8 != null ? Double.valueOf(string8) : d;
            ((Plot)this._plot).addPointWithErrorBars(this._currentDataset, d, d2, d3, d4, string6, color, n, bl);
        }
    }
}

