/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.gui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import ptolemy.gui.CancelException;

public class MessageHandler {
    private static MessageHandler _handler = new MessageHandler();

    public static void error(String string) {
        _handler._error(string);
    }

    public static void error(String string, Throwable throwable) {
        _handler._error(string, throwable);
    }

    public static String shortDescription(Throwable throwable) {
        String string = null;
        string = throwable instanceof Exception ? "Exception" : (throwable instanceof Error ? "Error" : "Throwable");
        return string;
    }

    public static MessageHandler getMessageHandler() {
        return _handler;
    }

    public static void message(String string) {
        _handler._message(string);
    }

    public static void setMessageHandler(MessageHandler messageHandler) {
        if (messageHandler != null) {
            _handler = messageHandler;
        }
    }

    public static void warning(String string) throws CancelException {
        _handler._warning(string);
    }

    public static void warning(String string, Throwable throwable) throws CancelException {
        _handler._warning(string + ": " + throwable.getMessage(), throwable);
    }

    public static boolean yesNoQuestion(String string) {
        return _handler._yesNoQuestion(string);
    }

    protected void _error(String string) {
        System.err.println(string);
    }

    protected void _error(String string, Throwable throwable) {
        if (throwable instanceof CancelException) {
            return;
        }
        System.err.println(string);
        throwable.printStackTrace();
    }

    protected void _message(String string) {
        System.err.println(string);
    }

    protected void _warning(String string) throws CancelException {
        this._error(string);
    }

    protected void _warning(String string, Throwable throwable) throws CancelException {
        this._error(string, throwable);
    }

    protected boolean _yesNoQuestion(String string) {
        System.out.print(string);
        System.out.print(" (yes or no) ");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        try {
            String string2 = bufferedReader.readLine();
            if (string2.trim().toLowerCase().equals("yes")) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

