% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findbreak.R
\name{findbreak}
\alias{findbreak}
\title{Find spaital breaking locations and add a column of breaks.}
\usage{
findbreak(start = "SLK.start", end = "SLK.end", data,
                 dist.allow = 0.05, line.no = NULL)
}
\arguments{
\item{start}{A character of start location name of a spatial line.}

\item{end}{A character of end location name of a spatial line.}

\item{data}{A data frame of a dataset.}

\item{dist.allow}{A number of the maximum allowed breaks within a line segment.}

\item{line.no}{A character of spatial line name.}
}
\description{
Find spaital breaking locations and add a column of breaks.
}
\examples{
testdata <- tsdwa[1:100,]
testdata <- findbreak(start = "SLK.start", end = "SLK.end",
                      data = testdata, dist.allow = 0.05)

}
