% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.track.r
\name{calc.track}
\alias{calc.track}
\title{Calculate most probable track from state estimates}
\usage{
calc.track(distr, g, dateVec, iniloc, method = "mean")
}
\arguments{
\item{distr}{is output array from \code{hmm.smoother}}

\item{g}{is one of the outputs from \code{resample.grid} which denotes what 
spatial scale and grid you're working on}

\item{dateVec}{is vector of dates from tag to pop-up in 1 day increments.}

\item{iniloc}{is matrix of tag and pop locations. Default is NULL because
this should be taken care of elsewhere.}

\item{method}{is character indicating what method to use for track 
calculation. Currently only 'mean' and 'max' are supported.}
}
\value{
calculated track
}
\description{
\code{calc.track} uses HMM output via \code{hmm.smoother} to calculate most 
probable track and behavior state
}
\examples{
\dontrun{

# GET THE MOST PROBABLE TRACK
tr <- calc.track(s, g, dateVec, iniloc)

}

}
