% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HEMDAG.1.0.0.R
\name{AUPRC.single.over.classes}
\alias{AUPRC.single.over.classes}
\title{AUPRC over classes}
\usage{
AUPRC.single.over.classes(target, pred)
}
\arguments{
\item{target}{matrix with the target multilabels: rows correspond to examples and columns to classes. 
\eqn{target[i,j]=1} if example \eqn{i} belongs to class \eqn{j}, \eqn{target[i,j]=0} otherwise.}

\item{pred}{a numeric matrix with predicted values (scores): rows correspond to examples and columns to classes.}
}
\value{
a list with two elements:
\enumerate{
\item average: the average AUPRC across classes;        
\item per.class: a named vector with AUPRC for each class. Names correspond to classes
}
}
\description{
High-level function to compute the Area under the Precision Recall Curve (AUPRC) across a set of classes through \pkg{precrec} package
}
\examples{
data(labels);
data(scores);
data(graph);
root <- root.node(g);
L <- L[,-which(colnames(L)==root)];
S <- S[,-which(colnames(S)==root)];
PRC <- AUPRC.single.over.classes(L,S);
}
\seealso{
\code{\link{AUPRC.single.class}}
}
