% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_custom_portfol.R
\name{new_MeanVar_portfolio}
\alias{new_MeanVar_portfolio}
\title{A constructor for class MeanVar_portfolio}
\usage{
new_MeanVar_portfolio(mean_vec, cov_mtrx, gamma)
}
\arguments{
\item{mean_vec}{mean vector of asset returns}

\item{cov_mtrx}{the covariance matrix of asset returns}

\item{gamma}{a numeric variable. Coefficient of risk aversion.}
}
\value{
Mean-variance portfolio in the form of object of S3 class MeanVar_portfolio.
}
\description{
A light-weight constructor of objects of S3 class MeanVar_portfolio. This  function is for development purposes.
A helper function equipped with error messages and allowing more flexible input is \code{\link{MeanVar_portfolio}}.
}
\examples{
n<-3e2 # number of realizations
p<-.5*n # number of assets
gamma<-1

x <- matrix(data = rnorm(n*p), nrow = p, ncol = n)

# Simple MV portfolio
cov_mtrx <- Sigma_sample_estimator(x)
means <- rowMeans(x)

cust_port_simp <- new_MeanVar_portfolio(mean_vec=means, cov_mtrx=cov_mtrx, gamma=2)
str(cust_port_simp)

# Portfolio with Bayes-Stein shrunk means
# and a Ledoit and Wolf estimator for covariance matrix
TM <- matrix(0, p, p)
diag(TM) <- 1
cov_mtrx <- CovarEstim(x, type="LW20", TM=TM)
means <- rowMeans(x)

cust_port_BS_LW <- new_MeanVar_portfolio(mean_vec=means, cov_mtrx=cov_mtrx, gamma=2)
str(cust_port_BS_LW)
}
