% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mean_shrink.R
\name{mean_js}
\alias{mean_js}
\title{James-Stein shrinkage estimator of the mean vector}
\usage{
mean_js(x, Y_0 = 1)
}
\arguments{
\item{x}{a numeric data matrix. Rows represent different variables, columns- observations.}

\item{Y_0}{a numeric variable. Shrinkage target coefficient.}
}
\value{
a numeric vector containing the James-Stein shrinkage estimator of the mean vector.
}
\description{
James-Stein shrinkage estimator of the mean vector as suggested in \insertCite{Jorion1986;textual}{HDShOP}.
The estimator is given by \deqn{\hat \mu_{JS} = (1-\beta) \bar x + \beta Y_0 1 \quad ,}
where \eqn{\bar x} is the sample mean vector, \eqn{\beta} is the shrinkage
coefficient which minimizes a quadratic loss given by Eq.(11) in \insertCite{Jorion1986;textual}{HDShOP}.
\eqn{Y_0} is a prespecified value.
}
\examples{
n<-7e2 # number of realizations
p<-.5*n # number of assets
x <- matrix(data = rnorm(n*p), nrow = p, ncol = n)
mm <- mean_js(x=x, Y_0 = 1)
}
\references{
\insertAllCited{}
}
