# plot.patterns.R
# Created by Mingzhou Song
# Modified by Jiandong Wang and Sajal Kumar
# Copyright (c) NMSU Song lab

#' Plotting the continuous data along with cluster-preserving Grid
#' 
#' Plots examples of jointly discretizing continuous data based on grids that 
#' preserve clusters in the original data.
#' 
#' @importFrom grDevices colorRampPalette palette
#' @importFrom graphics abline legend mtext par plot strheight strwidth
#' @importFrom plotrix color.legend
#' 
#' @param data a matrix containing two or more continuous variables.
#' Columns are variables, rows are observations.
#'
#' @param res the result generated by discretize.jointly
#' 
#' @export
plotGOCpatterns = function(data, res)
{
   k = length(unique(res$clabels))
   mar = c(2.5,2.5,2.5,3.5)
   par(mar=mar, mgp=c(3,1,0)-c(1.5,0.5,0), lwd=2)
   dims = dim(data)[2]
   
   col.palette = palette()[-1]
   l = 0
   for(i in c(1:(dims-1))){
      for(j in c((i+1):dims)){
         l = l + 1
         col <- col.palette[l]
         labelcol <- colorRampPalette(c("black", col))
         plot(data[,i], data[,j], main="", col=labelcol(k)[res$clabels], 
              pch=19, cex.axis=0.8, cex=0.7, xlab = paste0("dimension ",i), ylab = paste0("dimension ",j))
         mtext(text = "Original Data", side = 3, line = 1, cex=1.5)
         abline(v=res$grid[[i]], h=res$grid[[j]], col="black", lty="dotted")
         tab <- as.matrix(table(-res$D[, j], res$D[, i]))
         coord <- par("usr")
         color.legend(xl = coord[2]+strwidth("0")*3,
                      xr = coord[2]+strwidth("0")*5,
                      yb = mean(c(coord[4],coord[3])), 
                      yt = coord[4], 
                      legend = seq(length(unique(res$clabels))),
                      rect.col = unique(labelcol(k)[seq(length(unique(res$clabels)))]), 
                      gradient="y")
         FunChisq::plot_table(
            tab, xlab=paste0("dimension ",i), ylab=paste0("dimension ",j),
            col=col, main="Discretized data", highlight="none", 
            mar = c(2.5, 2.5, 2.5, 2.5))
      }
   }
}