% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printCrudeAndAdjustedModel.R
\name{printCrudeAndAdjustedModel}
\alias{printCrudeAndAdjustedModel}
\alias{rbind.printCrudeAndAdjusted}
\alias{print.printCrudeAndAdjusted}
\alias{htmlTable.printCrudeAndAdjusted}
\alias{[.printCrudeAndAdjusted}
\alias{cbind.printCrudeAndAdjusted}
\alias{knit_print.printCrudeAndAdjusted}
\alias{latex.printCrudeAndAdjusted}
\title{Output crude and adjusted model data}
\usage{
printCrudeAndAdjustedModel(
  model,
  order,
  digits = 2,
  ci_lim = c(-Inf, Inf),
  sprintf_ci_str = getOption("sprintf_ci_str", "\%s to \%s"),
  add_references,
  add_references_pos,
  reference_zero_effect,
  groups,
  rowname.fn,
  use_labels = TRUE,
  desc_column = FALSE,
  desc_args = caDescribeOpts(digits = digits),
  impute_args,
  ...
)

\method{rbind}{printCrudeAndAdjusted}(..., alt.names, deparse.level = 1)

\method{print}{printCrudeAndAdjusted}(x, css.rgroup = "", ...)

\method{htmlTable}{printCrudeAndAdjusted}(x, css.rgroup = "", ...)

\method{[}{printCrudeAndAdjusted}(x, i, j, ...)

\method{cbind}{printCrudeAndAdjusted}(..., alt.names, deparse.level = 1)

\method{knit_print}{printCrudeAndAdjusted}(x, css.rgroup = "", ...)

\method{latex}{printCrudeAndAdjusted}(object, ...)
}
\arguments{
\item{model}{A regression model fit, i.e. the returned object from your 
regression function, or the output from \code{\link{getCrudeAndAdjustedModelData}()}}

\item{order}{A vector with regular expressions for each group, use if youe
want to reorder the groups in another way than what you've used in your original
function. You can also use this in order to skip certain variables from the output.}

\item{digits}{The number of digits to round to}

\item{ci_lim}{A limit vector number that specifies if any values should be 
abbreviated above or below this value, for instance a value of 1000 
would give a value of \code{> -1000} for a value of 1001. This gives
a prettier table when you have very wide confidence intervals.}

\item{sprintf_ci_str}{A string according to \code{\link{sprintf}()} to 
write the confidence interval where the first \%s is the lower and 
the second the upper. You can choose to set this through setting the option 
\code{sprintf_ci_str}, e.g. \code{options(sprintf_ci_str = "\%s - \%s")}.}

\item{add_references}{True if it should use the data set to look for 
references, otherwise supply the function with a vector with names. 
Sometimes you want to indicate the reference row for each group. 
This needs to be just as many as the  groups as the order identified. 
Use NA if you don't want to have a reference for that particular group.}

\item{add_references_pos}{The position where a reference should be added. 
Sometimes you don't want the reference to be at the top, for instance 
if you have age groups then you may have < 25, 25-39, 40-55, > 55 and
you have the reference to be 25-39 then you should set the reference 
list for \code{age_groups} as \code{add_references_pos = list(age_groups = 2)}
so that you have the second group as the position for the reference.}

\item{reference_zero_effect}{Used with references, tells if zero effect 
is in exponential form, i.e. \code{exp(0) = 1}, or in regular format, 
i.e. \code{0 = 0} (can be set to any value)}

\item{groups}{If you wish to have other than the default \code{rgroup} names
for the grouping parameter}

\item{rowname.fn}{A function that takes a row name and sees if it needs
beautifying. The function has only one parameter the coefficients name and 
should return a string or expression.}

\item{use_labels}{If the rowname.fn function doesn't change the name then 
the label should be used instead of the name, that is if there is a
label and it isn't a factor.}

\item{desc_column}{Add descriptive column to the crude and adjusted table}

\item{desc_args}{The description arguments that are to be used for the
the description columns. The options/arguments should be generated by the 
\code{\link{caDescribeOpts}} function.}

\item{impute_args}{A list with additional arguments if the provided input is
a imputed object. Currently the list options \code{coef_change} and
\code{variance.inflation} are supported. If you want both columns then
the simplest way is to provide the list: 
\code{list(coef_change=TRUE, variance.inflation=TRUE)}.
The \code{coef_change} adds a column with the change in coefficients due to 
the imputation, the the "raw" model is subtracted from the imputed results.
The "raw" model is the unimputed model, \code{coef(imputed_model) - coef(raw_model)}.
The \code{variance.inflation} adds the \code{variance.inflation.impute} from the 
\code{\link[Hmisc]{fit.mult.impute}()} to a separate column. See the description
for the \code{variance.inflation.impute} in in the \code{\link[Hmisc]{fit.mult.impute}()}
description.
Both arguments can be customized by providing a \code{list}. The list can have
the elements \code{type}, \code{name}, \code{out_str}, and/or \code{digits}.
The \code{type} can for \code{coef_change}/\code{variance.impute} be either 
"percent" or "ratio", note that \code{variance.inflation.impute} was not
originally intended to be interpreted as \%. The default for \code{coef_change} is to 
have "diff", that gives the absolute difference in the coefficient.
The \code{name} provides the column name, the \code{out_str} should be a string
that is compatible with \code{\link[base]{sprintf}()} and also contains an argument
for accepting a float value, e.g. "%.0f%%" is used by default iun the coef_change
column. The \code{digits} can be used if you are not using the \code{out_str}
argument, it simply specifies the number of digits to show. See the example
for how for a working example.
\emph{Note} that currently only the \code{\link[Hmisc]{fit.mult.impute}()}
is supported by this option.}

\item{...}{outputs from printCrudeAndAdjusted. If mixed then it defaults to rbind.data.frame}

\item{alt.names}{If you don't want to use named arguments for the tspanner attribute in the rbind
or the cgroup in the cbind but a vector with names then use this argument.}

\item{deparse.level}{backward compatibility}

\item{x}{The output object from the printCrudeAndAdjustedModel function}

\item{css.rgroup}{Css style for the rgorup, if different styles are wanted for each of the
rgroups you can just specify a vector with the number of elements. Passed on to \code{\link{htmlTable}()}.}

\item{object}{The output object from the printCrudeAndAdjustedModel function}
}
\value{
\code{matrix} Returns a matrix of class printCrudeAndAdjusted that 
 has a default print method associated with
}
\description{
Prints table for a fitted object. It prints by default a latex table but can 
also be converted into a HTML table that should be more compatible with common
word processors. For details run \code{vignette("printCrudeAndAdjustedModel")}
}
\section{Warning}{

If you call this function and you've changed any of the variables
used in the original call, i.e. the premises are changed, this function will not
remember the original values and the statistics will be faulty!
}

\examples{
# simulated data to use 
set.seed(10)
ds <- data.frame(
  ftime = rexp(200),
  fstatus = sample(0:1,200,replace=TRUE),
	Variable1 = runif(200),
  Variable2 = runif(200),
  Variable3 = runif(200),
  Variable4 = factor(sample(LETTERS[1:4], size=200, replace=TRUE)))

library(rms)
dd <- datadist(ds)
options(datadist="dd")

fit <- cph(Surv(ftime, fstatus) ~ Variable1 + Variable3 + Variable2 +  Variable4,
           data=ds, x=TRUE, y=TRUE)
printCrudeAndAdjustedModel(fit, order = c("Variable[12]", "Variable3"))
printCrudeAndAdjustedModel(fit, 
                           order=c("Variable3", "Variable4"),
                           add_references = TRUE, 
                           desc_column=TRUE)

# Now to a missing example
n <- 500
ds <- data.frame(
  x1 = factor(sample(LETTERS[1:4], size = n, replace = TRUE)),
  x2 = rnorm(n, mean = 3, 2),
  x3 = factor(sample(letters[1:3], size = n, replace = TRUE)))

ds$Missing_var1 <- factor(sample(letters[1:4], size=n, replace=TRUE))
ds$Missing_var2 <- factor(sample(letters[1:4], size=n, replace=TRUE))
ds$y <- rnorm(nrow(ds)) +
  (as.numeric(ds$x1)-1) * 1 +
  (as.numeric(ds$Missing_var1)-1)*1 + 
  (as.numeric(ds$Missing_var2)-1)*.5

# Create a messy missing variable
non_random_missing <- sample(which(ds$Missing_var1 \%in\% c("b", "d")), 
                             size = 150, replace=FALSE)
# Restrict the non-random number on the x2 variables
non_random_missing <- non_random_missing[non_random_missing \%in\%
                                           which(ds$x2 > mean(ds$x2)*1.5) &
                                           non_random_missing \%in\%
                                           which(ds$x2 > mean(ds$y))]
ds$Missing_var1[non_random_missing] <- NA

# Simple missing variable
ds$Missing_var2[sample(1:nrow(ds), size=50)] <- NA

# Setup the rms environment
ddist <- datadist(ds)
options(datadist = "ddist")

impute_formula <- 
  as.formula(paste("~",
                   paste(colnames(ds),
                         collapse="+")))

imp_ds <- aregImpute(impute_formula, data = ds, n.impute = 10)

fmult <- fit.mult.impute(y ~ x1 + x2 + x3 + 
                           Missing_var1 + Missing_var2, 
                         fitter = ols, xtrans = imp_ds, data = ds)

printCrudeAndAdjustedModel(fmult, 
                           impute_args = list(variance.inflation=TRUE,
                                              coef_change=list(type="diff",
                                                               digits=3)))


# Use some labels to prettify the output
# fro the mtcars dataset
data("mtcars")

label(mtcars$mpg) <- "Gas"
units(mtcars$mpg) <- "Miles/(US) gallon"

label(mtcars$wt) <- "Weight"
units(mtcars$wt) <- "10^3 kg" # not sure the unit is correct 

mtcars$am <- factor(mtcars$am, levels=0:1, labels=c("Automatic", "Manual"))
label(mtcars$am) <- "Transmission"

mtcars$gear <- factor(mtcars$gear)
label(mtcars$gear) <- "Gears"

# Make up some data for making it slightly more interesting
mtcars$col <- factor(sample(c("red", "black", "silver"), size=NROW(mtcars), replace=TRUE))
label(mtcars$col) <- "Car color"

require(splines)
fit_mtcar <- lm(mpg ~ wt + gear + col, data=mtcars)
printCrudeAndAdjustedModel(fit_mtcar, 
                           add_references=TRUE,
                           ctable=TRUE, 
                           desc_column = TRUE,
                           digits=1,
                           desc_args = caDescribeOpts(digits = 1,
                                                      colnames = c("Avg.")))

printCrudeAndAdjustedModel(fit_mtcar, 
                           add_references=TRUE,
                           desc_column=TRUE,
                           order=c("Interc", "gear"))

# Alterntive print - just an example, doesn't make sense to skip reference
printCrudeAndAdjustedModel(fit_mtcar, 
                           order=c("col", "gear"), 
                           groups=c("Color", "Gears"),
                           add_references=c("black", NA),
                           ctable=TRUE)

# Now we can also combine models into one table using rbind()
mpg_model <- printCrudeAndAdjustedModel(lm(mpg ~ wt + gear + col, data=mtcars), 
                                    add_references=TRUE,
                                    ctable=TRUE, 
                                    desc_column = TRUE,
                                    digits=1,
                                    desc_args = caDescribeOpts(digits = 1,
                                                               colnames = c("Avg.")))

wt_model <- printCrudeAndAdjustedModel(lm(wt ~ mpg + gear + col, data=mtcars), 
                                    add_references=TRUE,
                                    ctable=TRUE, 
                                    desc_column = TRUE,
                                    digits=1,
                                    desc_args = caDescribeOpts(digits = 1,
                                                               colnames = c("Avg.")))

library(magrittr)
rbind(Miles = mpg_model, Weight = wt_model) \%>\% 
  htmlTable(caption="Combining models together with a table spanner element separating each model")
}
\seealso{
\code{\link[Hmisc]{latex}()} for details.

Other printCrudeAndAdjusted functions: 
\code{\link{prCaAddRefAndStat}()},
\code{\link{prCaAddReference}()},
\code{\link{prCaAddUserReferences}()},
\code{\link{prCaGetImputationCols}()},
\code{\link{prCaGetRowname}()},
\code{\link{prCaGetVnStats}()},
\code{\link{prCaPrepareCrudeAndAdjusted}()},
\code{\link{prCaReorderReferenceDescribe}()},
\code{\link{prCaReorder}()},
\code{\link{prCaSelectAndOrderVars}()},
\code{\link{prCaSetRownames}()}
}
\concept{printCrudeAndAdjusted functions}
\keyword{internal}
