/*
 * Decompiled with CFR 0.152.
 */
package ExperimentalDesign;

import ExperimentalDesign.AllExperimentalDesigns;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class MultipleSearchExperimentalDesigns
extends AllExperimentalDesigns {
    protected int max_designs;
    protected int[][] ending_indicTs;
    protected Double[] objective_vals;
    protected Integer[] num_iters;
    protected AtomicInteger num_completed;

    @Override
    public void beginSearch() {
        super.beginSearch();
        this.num_completed = new AtomicInteger(0);
        this.num_iters = new Integer[this.max_designs];
        this.ending_indicTs = new int[this.max_designs][this.n];
        this.objective_vals = new Double[this.max_designs];
    }

    public void setMaxDesigns(int n) {
        this.max_designs = n;
    }

    public int[] getNumIters() {
        int[] nArray = new int[this.num_completed.get()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.num_iters[i];
        }
        return nArray;
    }

    public double[] getObjectiveVals() {
        double[] dArray = new double[this.num_completed.get()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.objective_vals[i] == null ? 0.0 : this.objective_vals[i];
        }
        return dArray;
    }

    public int[][] getEndingIndicTs(int n) {
        int[] nArray = new int[]{n};
        return this.getEndingIndicTs(nArray);
    }

    public int[][] getEndingIndicTs(int[] nArray) {
        int[][] nArray2 = new int[nArray.length][this.n];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = this.ending_indicTs[nArray[i]];
        }
        return nArray2;
    }

    public int[][] getEndingIndicTs() {
        return this.ending_indicTs;
    }
}

