/*
 * Decompiled with CFR 0.152.
 */
package DesignMetrics;

public class RandomizationMetrics {
    private int n;
    private int r;
    private int[][] ending_indicTs;
    private double[][] p_hat_same_group;
    private double entropy_metric;
    private double se_metric;

    public static void main(String[] stringArray) {
        RandomizationMetrics randomizationMetrics = new RandomizationMetrics();
        int[] nArray = new int[]{1, 0, 1, 0, 1, 0, 0};
        int[] nArray2 = new int[]{1, 1, 1, 0, 1, 0, 0};
        int[] nArray3 = new int[]{1, 0, 1, 0, 1, 0, 0};
        int[] nArray4 = new int[]{1, 0, 1, 0, 1, 0, 0};
        int[] nArray5 = new int[]{1, 0, 1, 0, 1, 0, 0};
        randomizationMetrics.setNandR(7, 5);
        randomizationMetrics.setDesign(0, nArray);
        randomizationMetrics.setDesign(1, nArray2);
        randomizationMetrics.setDesign(2, nArray3);
        randomizationMetrics.setDesign(3, nArray4);
        randomizationMetrics.setDesign(4, nArray5);
        randomizationMetrics.compute();
    }

    public void setNandR(int n, int n2) {
        this.n = n;
        this.r = n2;
        this.ending_indicTs = new int[n2][n];
    }

    public void setDesigns(int[][] nArray) {
        this.ending_indicTs = nArray;
    }

    public void setDesign(int n, int[] nArray) {
        for (int i = 0; i < this.n; ++i) {
            this.ending_indicTs[n][i] = nArray[i];
        }
    }

    private void estimatePhats() {
        this.p_hat_same_group = new double[this.n][this.n];
        for (int i = 0; i < this.n - 1; ++i) {
            for (int j = i + 1; j < this.n; ++j) {
                int n = 0;
                for (int k = 0; k < this.r; ++k) {
                    n += this.ending_indicTs[k][i] == this.ending_indicTs[k][j] ? 1 : 0;
                }
                this.p_hat_same_group[i][j] = (double)n / (double)this.r;
            }
        }
    }

    public void compute() {
        double d;
        this.estimatePhats();
        double d2 = (double)(this.n - 2) / (double)(2 * this.n - 2);
        int n = this.n * (this.n - 1) / 2;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < this.n - 1; ++i) {
            for (int j = i + 1; j < this.n; ++j) {
                d = this.p_hat_same_group[i][j];
                d3 += this.probTimesLogProb(d) + this.probTimesLogProb(1.0 - d);
                d4 += Math.pow(d - d2, 2.0);
            }
        }
        double d5 = d2 * Math.log(d2) + (1.0 - d2) * Math.log(1.0 - d2);
        this.entropy_metric = 1.0 / (double)n * d3 / d5;
        d = 2.0 / (double)this.n * Math.sqrt((double)(2 * this.n - 2) / (double)(this.n - 2));
        this.se_metric = d * Math.sqrt(d4);
    }

    private double probTimesLogProb(double d) {
        if (d == 0.0) {
            return 0.0;
        }
        return d * Math.log(d);
    }

    public double getRandEntropyMetric() {
        return this.entropy_metric;
    }

    public double getRandStdErrMetric() {
        return this.se_metric;
    }

    public double[][] getPhats() {
        return this.p_hat_same_group;
    }
}

