% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GKtauDataframe.R
\name{GKtauDataframe}
\alias{GKtauDataframe}
\title{Compute Goodman and Kruskal's tau for a dataframe.}
\usage{
GKtauDataframe(df, dgts = 3, includeNA = "ifany")
}
\arguments{
\item{df}{Dataframe from which to compute association measures.}

\item{dgts}{Integer, number of digits for results; optional (default = 3).}

\item{includeNA}{Character, passed to useNA parameter for table;
default is "ifany"; other valid options are "no" and "always"}
}
\value{
An S3 object of class 'GKtauMatrix' consisting of a square
matrix with one row and column for each column of the dataframe df.
The structure of this matrix is:
\itemize{
  \item row and column names are the names of the variables in the dataframe.
  \item the diagonal matrix element contains the number of unique levels for
  the corresponding variable.
  \item off-diagonal matrix elements contain the forward Goodman-Kruskal
  tau association from the variable listed in the row names to the
  variable listed in the column names.
}
}
\description{
\code{GKtauDataframe} returns the square matrix of Goodman and Kruskal
measures computed between each pair of columns in a dataframe.  Numeric
variables in the dataframe are treated as factors.
}
\details{
The Goodman and Kruskal tau measure is an asymmetric association measure
between two categorical variables, based on the extent to which variation
in one variable can be explained by the other.  This function returns an
S3 object of class 'GKtauMatrix' that gives the number of levels for
each variable on the diagonal of the matrix and the association between
variables in the off-diagonal elements.  Note that this matrix is
generally NOT symmetric, in contrast to standard correlation matrices.
}
\author{
Ron Pearson
}

