% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/KmtFunc.R
\name{KhmaladzeTrans}
\alias{KhmaladzeTrans}
\title{Performs goodness-of-fit test through Khmaladze matringale transformation}
\usage{
KhmaladzeTrans(X, F0)
}
\arguments{
\item{X}{- Random sample of n observations}

\item{F0}{- Name of null distribution: Normal, Cauchy, or Logistic}
}
\value{
TestStat - Test statistic obtained through Khmaladze martingale transformation

CritValue - Vector of critical values for the level of 0.01, 0.025, 0.05, and 0.10

Mu - Maximum likelihood estimator of location parameter mu

Sigma - Maximum likelihood estimator of scale parameter sigma
}
\description{
Performs goodness-of-fit test through Khmaladze matringale transformation
}
\examples{
####################
n = 10
Sample = rnorm(n, 1,3)    # Generate a random sample of n observations from N(1,3)
KMT_Result = KhmaladzeTrans(Sample, "Normal")
KMT_TestStat = KMT_Result$TestStat
KMT_CriticalValue = KMT_Result$CritValue
KMT_Muhat = KMT_Result$Mu
KMT_Sigmahat = KMT_Result$Sigma
#####################

#####################
n = 10
Sample = rcauchy(n, 0,2)  # Generate a random sample of n observations from Cauchy distribution
KMT_Result = KhmaladzeTrans(Sample, "Cauchy")
KMT_TestStat = KMT_Result$TestStat
KMT_CriticalValue = KMT_Result$CritValue
KMT_Muhat = KMT_Result$Mu
KMT_Sigmahat = KMT_Result$Sigma
#####################
}
\references{
[1] E.V. Khmaladze, H.L. Koul (2004). Martingale Transforms Goodness-of-fit tests in regression models. Ann. Statist., 32. 995-1034

[2] E.V. Khmaladze, H.L. Koul (2009). Goodness-of-fit problem for errors in nonparametric regression: Distribution free approach. Ann. Statist., 37(6A) 3165-3185.
}

