% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNa.R
\name{NNa}
\alias{NNa}
\title{R function for Nearest Neighbor analysis of point patterns}
\usage{
NNa(feature, studyplot = NULL, buffer = 0, B = 199, cov.var = NULL,
  addmap = TRUE)
}
\arguments{
\item{feature}{Feature dataset (of point type; SpatialPointsDataFrame class).}

\item{studyplot}{Shapefile (of polygon type; SpatialPolygonsDataFrame class) representing the
study area; if not provided, the study area is internally worked out as the convex hull
enclosing the input feature dataset.}

\item{buffer}{Add a buffer to the studyplot (0 by default); the unit depends upon the units of
the input data.}

\item{B}{Number of randomizations to be used (199 by default).}

\item{cov.var}{Numeric covariate (of 'RasterLayer' class).}

\item{addmap}{TRUE (default) or FALSE if the user wants or does not want a map of the study area
and of feature dataset to be also displayed.}
}
\value{
The function returns a list storing the following components \itemize{
 \item{$obs.aver.NN.dist: }{average of the observed NN distances}
 \item{$obs.R: }{observed R value}
 \item{$aver.rand.R: }{average of the randomized Rs}
 \item{$p.value clustered: }{p-value for a clustered pattern}
 \item{$p.value.dispersed: }{p-value for a dispersed pattern}
 \item{$p.value.diff.from.random: }{p-value for a pattern different from random}
}
}
\description{
The function allows to perform the Nearest Neighbor analysis of point patterns to formally test
for the presence of a clustered, dispersed, or random spatial arrangement (second-order effect).
It also allows to control for a first-order effect (i.e., influence of an underlaying numerical
covariate) while performing the analysis. The covariate must be of RasterLayer class.
Significance is assessed via a randomized approach.\cr
}
\details{
The function uses a randomized approach to test the significance of the Clark-Evans R statistic:
the observed R value is set against the distribution of R values computed across B iterations
(199 by default) in which a set of random points (with a sample size equal to the number of
points of the input feature) is drawn and the statistic recomputed.\cr

The function produces a histogram of the randomized R values, with a black dot indicating the
observed value and a hollow dot representing the average of the randomized R values. P-values
(computed following Baddeley et al., "Spatial Point Patterns. Methodology and Applications with
R", CRC Press 2016, p. 387), are reported at the bottom of the same chart. Two reference lines
represent the two tails of the randomized distribution (left tail, indicating a significant
clustered pattern; right tail, indicating a significant dispersed pattern).\cr
}
\examples{
data(springs)

#perform the analysis with B set to 99; the result points to a significant clustering
res <- NNa(springs, B=99)

data(Starbucks)
data(popdensity)

#perform the analysis, while controlling for the effect of the population density covariate
res <- NNa(Starbucks, cov.var=popdensity, B=99)

}
\seealso{
\code{\link{refNNa}}
}
\keyword{NNa}
