% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbcbd_get_series.R
\name{gbcbd_get_single_series}
\alias{gbcbd_get_single_series}
\title{Gets a single series from BCB-SGS (internal use)}
\usage{
gbcbd_get_single_series(
  id,
  series.name = paste0("SGS ", id),
  first.date = Sys.Date() - 360,
  last.date = Sys.Date(),
  format.data = "long",
  be.quiet = FALSE,
  use.memoise = TRUE,
  cache.path = gbcbd_get_default_cache_folder()
)
}
\arguments{
\item{id}{Id of series from BCB-SGS}

\item{series.name}{Name of time series}

\item{first.date}{First date of time series}

\item{last.date}{Last date of time series}

\item{format.data}{The format of the datasets - long (default, series incremented by rows) or wide (series incremented by columns)}

\item{be.quiet}{Logical. Should functions output messages to screen? - FALSE (default) or TRUE}

\item{use.memoise}{Logical. Sets the use of caching system - TRUE (default) or FALSE}

\item{cache.path}{Path to save cache files - 'rbcb2_cache' (default)}
}
\value{
A dataframe for a single series
}
\description{
This function should not be called directly. Its a helper for gbcbd_get_series
}
\examples{
df <- gbcbd_get_single_series(id = 1, cache.path = tempdir())
}
