% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iso_female.R
\name{create_iso_female}
\alias{create_iso_female}
\title{Create isofemale}
\usage{
create_iso_female(
  source_pop,
  n = 1,
  inbreeding_pop_size = 100,
  run_time = 2000,
  morgan = 1,
  seed = 42,
  progress_bar = FALSE
)
}
\arguments{
\item{source_pop}{Source population from which isofemales are generated}

\item{n}{Number of isofemales to be generated}

\item{inbreeding_pop_size}{Population size of the population used to generate
homozygous individuals}

\item{run_time}{Maximum runtime used for inbreeding}

\item{morgan}{Size of the chromosome in Morgan (e.g. the number of crossovers
during meiosis)}

\item{seed}{Random number generator seed}

\item{progress_bar}{Displays a progress_bar if TRUE. Default value is FALSE}
}
\value{
A list of length \code{n}, where each entry is a fully homozygous
isofemale.
}
\description{
Creates isofemale individuals, given a population
}
\details{
To create an isofemale, two individuals are randomly picked from
the source population. Using these two individuals, a new population is
seeded, of size \code{inbreeding_pop_size}. Then, this population is allowed
to inbreed until either \code{run_time} is reached, or until all individuals
are homozygous and genetically identical, whatever happens first.
}
\examples{
\donttest{
wildpop =  simulate_admixture(pop_size = 100,
                              number_of_founders = 10,
                              total_runtime = 5,
                              morgan = 1)

isofemale <- create_iso_female(source_pop = wildpop,
                               n = 1,
                               inbreeding_pop_size = 100,
                               run_time = 100,
                               morgan = 1)
}
}
