% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.R
\name{find_common_subtrees}
\alias{find_common_subtrees}
\title{Find the set of common subtrees between two phylogenetic trees}
\usage{
find_common_subtrees(phylotree_1, phylotree_2, labels = FALSE)
}
\arguments{
\item{phylotree_1}{A \code{Phylotree} class object.}

\item{phylotree_2}{A \code{Phylotree} class object.}

\item{labels}{A boolean, if \code{TRUE} the rendered graph will be plotted with the tags of the genes in the phylogenetic trees instead of their gene index. \code{FALSE} by default.}
}
\value{
A plot of the common subtrees between two phylogenetic trees and the information about the distance between them based on their independent and common edges.
}
\description{
Plots the common subtrees between two phylogenetic trees and prints the information about their similarities and their differences.
}
\examples{

# Load the predefined B matrices of the package
B_mats <- GeRnika::B_mats


B_real <- B_mats[[2]]$B_real
B_alg1 <- B_mats[[2]]$B_alg1


# Generate the tags for the genes of
# the phyogenetic tree
tags <- LETTERS[1:nrow(B_real)]


# Instantiate two Phylotree class objects on 
# the basis of the B matrices using tags
phylotree_real <- B_to_phylotree(
                    B = B_real, 
                    labels = tags)
                    
phylotree_alg1 <- B_to_phylotree(
                    B = B_alg1, 
                    labels = tags)


# find the set of common subtrees between both 
# phylogenetic trees
find_common_subtrees(
  phylotree_1 = phylotree_real, 
  phylotree_2 = phylotree_alg1)


# find the set of common subtrees between both
# phylogenetic trees using tags
find_common_subtrees(
  phylotree_1 = phylotree_real, 
  phylotree_2 = phylotree_alg1, 
  labels = TRUE)
}
