% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/em.step.R
\name{em.step}
\alias{em.step}
\title{Function to perform the E-M steps for the estimation of the paramters}
\usage{
em.step(y, mu, sigma, Q)
}
\arguments{
\item{y}{points at which the density function is comptuted (mx1);}

\item{mu}{vector of means for each regime (r x 1);}

\item{sigma}{vector of standard deviations for each regime (r x 1);}

\item{Q}{transition probality matrix (r x r);}
}
\value{
\item{f}{values of the density function at time n+k}

\item{w}{weights of the mixture}
}
\description{
This function perform the E-M steps for the estimation of the parameters
of a univariate Gaussian HMM.
}
\examples{
mu <- c(-0.3 ,0.7) ; sigma <- c(0.15,0.05); Q <- matrix(c(0.8, 0.3, 0.2, 0.7),2,2) ;
data <- Sim.HMM.Gaussian.1d(mu,sigma,Q,eta0=1,100)$x
out <- em.step(data,mu,sigma,Q)
}
\references{
Chapter 10.2 of B. Rémillard (2013). Statistical Methods for Financial Engineering,
Chapman and Hall/CRC Financial Mathematics Series, Taylor & Francis.
}
\author{
Bouchra R Nasri  and Bruno N Rémillard, January 31, 2019
}
