% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SummaryHTML.R
\name{SummaryHTML}
\alias{SummaryHTML}
\title{Creating a summary HTML document for each taxon}
\usage{
SummaryHTML(
  Species_list,
  Occurrence_data,
  Raster_list,
  Buffer_distance = 50000,
  Ecoregions_shp = NULL,
  Pro_areas = NULL,
  Output_Folder,
  writeRasters
)
}
\arguments{
\item{Species_list}{A species list to calculate metrics.}

\item{Occurrence_data}{A data frame object with the species name, geographical coordinates,
and type of records (G or H) for a given species}

\item{Raster_list}{A list representing the species distribution models for the species list provided
loaded in raster format. This list must match the same order as the species list.}

\item{Buffer_distance}{Geographical distance used to create circular buffers around germplasm.
Default: 50000 that is 50 km around germplasm accessions (CA50)}

\item{Ecoregions_shp}{A shapefile representing Ecoregions information with a field ECO_ID_U representing Ecoregions Ids.
If Ecoregions=NULL the function will use a shapefile provided for use after running GetDatasets()}

\item{Pro_areas}{A raster file representing protected areas information.
If Pro_areas=NULL the funtion will use a protected area raster file provided for your use after run GetDatasets()}

\item{Output_Folder}{A path to save the HTML file resulting of this function}

\item{writeRasters}{Boolean field (default=FALSE) to indicate if raster files should be saved}
}
\value{
This function returns a data frame file saved at a specified folder
}
\description{
Calls the summaryHTML rmd file information and displays
 the quantitative and spatial results content.
}
\examples{
\donttest{
##Obtaining occurrences from example
data(CucurbitaData)
##Obtaining species names from the data
Cucurbita_splist <- unique(CucurbitaData$species)
##Obtaining raster_list
data(CucurbitaRasters)
CucurbitaRasters <- raster::unstack(CucurbitaRasters)
##Obtaining protected areas raster
data(ProtectedAreas)
##Obtaining ecoregions shapefile
data(ecoregions)
##Get datasets
GetDatasets()
##Running SummaryHTML function
summaryHTML_file <- SummaryHTML(Species_list=Cucurbita_splist,
                                 Occurrence_data = CucurbitaData,
                                 Raster_list=CucurbitaRasters,
                                 Pro_areas=ProtectedAreas,
                                 Buffer_distance=50000,
                                 Ecoregions_shp=ecoregions,
                                 Output_Folder=tempdir(),
                                 writeRasters=FALSE)
}

}
\references{
Khoury et al. (2019) Diversity and Distributions 26(2):209-225. doi: 10.1111/DDI.13008
}
