% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_station_list.R
\name{update_station_list}
\alias{update_station_list}
\title{Download Latest Station List Metadata and Update Internal Database}
\usage{
update_station_list()
}
\description{
This function downloads the latest station list (isd-history.csv) from the
\acronym{NCEI} server and updates the data distributed with \pkg{GSODR} to
the latest stations available.  These data provide unique identifiers,
country, state (if in U.S.) and when weather observations begin and end.
}
\details{
Care should be taken when using this function if reproducibility is necessary
as different machines with the same version of \pkg{GSODR} can end up with
different versions of the isd_history.csv file internally.

There is no need to use this unless you know that a station exists in the
isd_history.csv file that is not available in \pkg{GSODR's} self-contained
database.

To directly access these data, use: \cr
\code{load(system.file("extdata", "isd_history.rda", package = "GSODR"))}
}
\examples{
\dontrun{
update_station_list()
}

}
\author{
Adam H. Sparks, \email{adamhsparks@gmail.com}
}
