% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Denoise.R
\name{gscad.denoise}
\alias{gscad.denoise}
\title{Use GSCAD to denoise image}
\usage{
gscad.denoise(I_noise, sigma, D0 = NULL, m, p0, c = 3.7, lambda = 0.05,
  maxrun = 20, maxrun_ADMM = 20, err_bnd = 1e-04, err_bnd2 = 1e-04,
  rho = 16, cor_bnd = 1, L = NULL)
}
\arguments{
\item{I_noise}{The image to be denoised. In form of matrix.}

\item{sigma}{Noise level.}

\item{D0}{Initial dictionary. If D0 specified, m and p0 are not needed, otherwise D0
is evaluated as overcompleted DCT basis using function ODCT(m,p0). Either D0
or (m,p0) needs to be specified.}

\item{m}{The size of the small patches to be split.}

\item{p0}{Initial size of the dictionary.}

\item{c, lambda}{Parameters for GSCAD.}

\item{maxrun}{(optional) Maximun number of outer iterations to run. Default is 20.}

\item{maxrun_ADMM}{(optional) Maximun number of iterations to run for updating
dictionary using ADMM. Default is 20.}

\item{err_bnd}{(optional) Stopping criterion for iterations. Default is 1e-4.}

\item{err_bnd2}{(optional) Stopping criterion for updating dictionary}

\item{rho}{(optional) Parameter for ADMM. Default is 16.}

\item{cor_bnd}{(optional) When normalize dictionary, checking if the correlation
of any two atoms are above the cor_bnd, one of the atom is removed. Default is 1.}

\item{L}{(optional) This parameter controls the maximum number of non-zero elements
in each column of sparsecolding A.Default is m.}
}
\value{
The learned dictionary \code{dictionary}, its size \code{p}
and the denoised image \code{fitted image}.
}
\description{
Use the GSCAD method under dictionary learning framework to learn a proper
sized dictionary and denoise image. The noisy image is split into m by m
patches and a dictionary with each atom of size m is learned. The final
denoised image is reconstruncted on the denoised patches.
}
\details{
See \url{https://arxiv.org/abs/1605.07870}
}
\examples{
I = lena_crop #use a smaller image as an example
## add noise
sigma=20;
I_noise=AddNoise(I,sigma)
## denoising using GSCAD
\dontrun{
out=gscad.denoise(I_noise,sigma,m=64,p0=100)
}
}
