% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regressors.R
\name{phenoRegressor.dummy}
\alias{phenoRegressor.dummy}
\title{Regression dummy function}
\usage{
phenoRegressor.dummy(phenotypes, genotypes, covariances, extraCovariates)
}
\arguments{
\item{phenotypes}{phenotypes, numeric array (n x 1), missing values are predicted}

\item{genotypes}{SNP genotypes, one row per phenotype (n), one column per marker (m), values in 0/1/2 for
diploids or 0/1/2/...ploidy for polyploids. Can be NULL if \code{covariances} is present.}

\item{covariances}{square matrix (n x n) of covariances. Can be NULL if \code{genotypes} is present.}

\item{extraCovariates}{extra covariates set, one row per phenotype (n), one column per covariate (w).
If NULL no extra covariates are considered.}
}
\value{
The function should return a list with the following fields:
\itemize{
  \item \code{predictions} : an array of (k) predicted phenotypes
  \item \code{hyperparams} : named array of hyperparameters selected during training
  \item \code{extradata}   : any extra information
}
}
\description{
This function is for development purposes. It returns, as "predictions", an array of
random numbers. It accept the standard inputs and produces a formally correct output. It
is, obviously, quite fast.
}
\examples{
#genotypes are not really investigated. Only
#number of test phenotypes is used.
phenoRegressor.dummy(
  phenotypes = c(1:10, NA, NA, NA),
  genotypes = matrix(nrow = 13, ncol=30)
)
}
\seealso{
Other phenoRegressors: \code{\link{phenoRegressor.BGLR}},
  \code{\link{phenoRegressor.RFR}},
  \code{\link{phenoRegressor.SVR}},
  \code{\link{phenoRegressor.rrBLUP}}
}
\concept{phenoRegressors}
