% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_srr.R
\name{get_srr}
\alias{get_srr}
\title{Download SRA run files}
\usage{
get_srr(srr_id, destdir, ascp, prefetch_workspace, ascp_path)
}
\arguments{
\item{srr_id}{SRA run accession ID.}

\item{destdir}{directory where all the results will be saved.}

\item{ascp}{logical, whether to use Aspera for downloading SRA files.}

\item{prefetch_workspace}{directory where SRA run files will be downloaded.
This parameter is needed if \code{ascp=TRUE}. 
The location of this directory can be found by going to the aspera 
directory (/.aspera/connect/bin/) and typing \code{'vdb-config -i'}.
A new window will pop-up and under the \code{'Workspace Name'}, 
you will find the location. Usually the default is 
\code{'/home/username/ncbi/public'}.}

\item{ascp_path}{path to the Aspera software.}
}
\value{
SRA run accession file with extension ".sra". If you use 
\code{ascp=TRUE}, then downloaded files will be saved under 
\code{'/prefetch_workspace/sra'} directory. 
If \code{ascp=FALSE}, then files will be saved in the 
\code{'destdir'}
}
\description{
\code{get_srr} downloads SRA files using Aspera or FTP. 
We recommend using Aspera for fast downloading. 
You need to install Aspera for using \code{ascp} option.
}
\examples{

\donttest{
get_srr(srr_id="SRR5890521", destdir=tempdir(),ascp=FALSE,
prefetch_workspace=NULL, ascp_path=NULL)
}

}
