#' A list providing the description of six models tested by
#' the function \code{autoGPoMoTest}.
#'
#' @name allToTest
#' @docType data
#' @author Sylvain Mangiarotti, Mireille Huc
#' @description List of 6 models available for tests (by \code{autoGPoMoTest}).
#' Each model (\code{$mToTest1}, \code{$mToTest2}, etc.) is provided as a matrix
#' of dimension 10 * 3. Each column corresponds to one equation.
#' The order of the coefficients follows the conventions defined
#' by \code{poLabs(nVar = 3, dMax = 2)}.
#' @examples
#' ###########
#' # example #
#' ###########
#' data("allToTest")
#' # 6 models are available in this list:
#' names(allToTest)
#' # The parameter of their formulation (nVar and dMax)
#' # can be retrieved:
#' nVar <- dim(allToTest$mToTest6)[2]
#' dMax <- p2dMax(nVar = 3, pMaxKnown = dim(allToTest$mToTest6)[1])
#' # Their equation can be edited as follows:
#' visuEq(nVar, dMax, allToTest$mToTest6, approx = 2)
#'
#' @keywords data
"allToTest"
