% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotParetoEmp.R
\name{plotParetoEmp}
\alias{plotParetoEmp}
\title{Pareto front visualization}
\usage{
plotParetoEmp(nondominatedPoints, add = TRUE, max = FALSE, bounds = NULL,
  alpha = 0.5, ...)
}
\arguments{
\item{nondominatedPoints}{points considered to plot the Pareto front with segments, matrix with one point per row,}

\item{add}{optional boolean indicating whether a new graphic should be drawn,}

\item{max}{optional boolean indicating whether to display a Pareto front in a maximization context,}

\item{bounds}{for 3D, optional 2*nobj matrix of boundaries}

\item{alpha}{for 3D, optional value in [0,1] for transparency}

\item{...}{additional values to be passed to the \code{\link[graphics]{lines}} function.}
}
\description{
Plot the Pareto front with step functions.
}
\examples{
#------------------------------------------------------------
# Simple example
#------------------------------------------------------------

x <- c(0.2, 0.4, 0.6, 0.8)
y <- c(0.8, 0.7, 0.5, 0.1)

plot(x, y, col = "green", pch = 20) 

plotParetoEmp(cbind(x, y), col = "green")
## Alternative
plotParetoEmp(cbind(x, y), col = "red", add = FALSE)

## With maximization
plotParetoEmp(cbind(x, y), col = "blue", max = TRUE)

## 3D plots
library(rgl)
set.seed(5)
X <- matrix(runif(60), ncol=3)
Xnd <- t(nondominated_points(t(X)))
plot3d(X)
plot3d(Xnd, col="red", size=8, add=TRUE)
plot3d(x=min(Xnd[,1]), y=min(Xnd[,2]), z=min(Xnd[,3]), col="green", size=8, add=TRUE)
X.range <- diff(apply(X,2,range))
bounds <- rbind(apply(X,2,min)-0.1*X.range,apply(X,2,max)+0.1*X.range)
plotParetoEmp(nondominatedPoints = Xnd, add=TRUE, bounds=bounds, alpha=0.5)

}
