% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train_GPS.R
\name{train_GPS}
\alias{train_GPS}
\title{Train A Model for GPS}
\usage{
train_GPS(cov_mt, w_all, dnorm_log = FALSE)
}
\arguments{
\item{cov_mt}{A covariate matrix containing all covariates. Each row is a
sample and each column is a covariate.}

\item{w_all}{A vector of observed exposure levels.}

\item{dnorm_log}{Logical, if TRUE, probabilities p are given as log(p).}
}
\value{
A data.table that includes:
\itemize{
\item a vector of estimated GPS at the observed exposure levels;
\item a vector of estimated conditional means of exposure levels when the covariates are fixed
at the observed values;
\item estimated standard deviation of exposure levels
}
}
\description{
Estimates the conditional mean and sd of exposure level as a function of
covariates with xgboost algorithm.
}
\examples{
mydata <- generate_synthetic_data()
GPS_m <- train_GPS(as.matrix(mydata[,c("cf1", "cf2", "cf3", "cf4",
                                          "cf5", "cf6")]),
                      as.matrix(mydata$treat))


}
