% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gnrs_super_simple.R
\name{GNRS_super_simple}
\alias{GNRS_super_simple}
\title{Standardize political division names}
\usage{
GNRS_super_simple(
  country = NULL,
  state_province = NULL,
  county_parish = NULL,
  user_id = NULL
)
}
\arguments{
\item{country}{A single country or a vector of countries.  If a vector, length must equal length of species vector.}

\item{state_province}{A single state/province or a vector of states.  If a vector, length must equal length of species vector.}

\item{county_parish}{A single county/parish or a vector of counties.  If a vector, length must equal length of species vector.}

\item{user_id}{A single identifier or vector of identifiers.  This field is assigned if not provided and is used to maintain record order.}
}
\value{
Dataframe containing GNRS results.
}
\description{
GNRS_super_simple returns standardized political division names (according to geonames.org).
}
\note{
The fields the GNRS takes as input are titled "country", "state_province", and "county_parish" for simplicity, but these field actually refer to 0th-, 1st-, and 2nd-order political division, respectively. In the case of some exceptions (e.g. the UK) this distinction becomes important (e.g. Ireland is a 1st-order poltical division and should be treated as a "state_province" and cannot be matched as a country.)
}
\examples{
{

 results <- GNRS_super_simple(country = "United States of America")
 results <- GNRS_super_simple(
             country = "United States",
             state_province = "Arizona",
             county_parish = "Pima County")

}
}
