% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{dens_est}
\alias{dens_est}
\title{Density estimator of resource abundance}
\usage{
dens_est(observation, paras, view = view, land = land)
}
\arguments{
\item{observation}{The array of resource observations from the observation model, used to estimate abundance of resources}

\item{paras}{The vector of parameters that hold global and dynamic parameter values used by GMSE}

\item{view}{This parameter determines the distance around an agent's location within which it can observe resources.}

\item{land}{The landscape array on which interactions between resources and agents occur}
}
\value{
The density estimator (which is also performed GMSE in the manager function) returns a list that includes resource population size estimates along with 95% confidence intervals
}
\description{
Estimates population size using simulated data produced by the
observation model of GMSE -- it assumes that the density of resources
observed on the subset of the landscape sampled equals the density on the 
whole landscape.
}
\examples{
\dontrun{
analysis <- dens_est(observation = obs_t, paras = paras, view = view,
land = land1);
}
}
