% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{predict_glmcat}
\alias{predict_glmcat}
\title{GLMcat model predictions}
\usage{
predict_glmcat(model_object = NaN, data, type = "prob")
}
\arguments{
\item{model_object}{a GLMcat model}

\item{data}{a data frame with the predictor variables used in the GLMcat model.}

\item{type}{The type of prediction to obtain. \code{"prob"} gives probabilities,
\code{"cum.prob"} gives cumulative probabilities and \code{"linear.predict"} gives
the linear predictor.}
}
\description{
GLMcat model predictions
}
\examples{
data(DisturbedDreams)
mod1 <- GLMcat(formula = Level ~ Age,
data = DisturbedDreams, distribution = "logistic")
predict_glmcat(mod1, data = DisturbedDreams[1:5, ], type = "prob")
}
