# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Family of models for Discrete Choice
#' @description Discrete choice model: Requires data in long form.
#' For each individual (or decision maker), there are multiple observations (rows),
#' one for each of the alternatives the individual could have chosen.
#' We call the group of observations for an individual a “case”.
#' Each case represents a single statistical observation although it comprises
#' multiple observations.
#' @param formula a symbolic description of the model to be fit. An expression of the form y ~ predictors is interpreted as a specification that the response y is modelled by a linear predictor specified symbolically by model. A particularity for the formula is that for the case-specific variables, the user can define a specific effect for a category.
#' @param case_id a string with the name of the column that identifies each case.
#' @param alternatives a string with the name of the column that identifies the vector of alternatives the individual could have chosen.
#' @param reference a string indicating the reference category
#' @param alternative_specific a character vector with the name of the explanatory variables that are different for each case, these are the alternative specific variables. By default, the case specific variables are the explanatory variables that are not identify in here, but that are part of the formula.
#' @param data a dataframe object in R, with the dependent variable as factor.
#' @param distribution a string indicating the F distribution, options are: logistic, normal, cauchit, student (any df), gompertz, gumbel.
#' @param freedom_degrees an optional scalar to indicate the degrees of freedom for the Student distribution.
#' @examples
#' library(GLMcat)
#' data(TravelChoice)
#' Discrete_CM(formula = choice ~ hinc + gc + invt,
#' case_id = "indv",alternatives = "mode",reference = "air",
#' data = TravelChoice,  alternative_specific = c("gc", "invt"),
#' distribution = "logistic")
#' @note For these models it is not allowed to exclude the intercept.
#' @export
Discrete_CM <- function(formula, case_id, alternatives, reference, alternative_specific, data, distribution, freedom_degrees) {
    .Call(`_GLMcat_Discrete_CM`, formula, case_id, alternatives, reference, alternative_specific, data, distribution, freedom_degrees)
}

#' Family of models for categorical responses (reference, adjacent, sequential and cumulative ratio)
#'
#' @param formula a symbolic description of the model to be fit. An expression of the form y ~ predictors is interpreted as a specification that the response y is modelled by a linear predictor specified symbolically by model.
#' @param ratio a string indicating the F distribution, options are: reference, adjacent, cumulative and sequential. Default value is reference.
#' @param distribution a string indicating the F distribution, options are: logistic, normal, cauchit, student (any df), gompertz, gumbel.
#' @param categories_order a character vector indicating the incremental order of the categories: c("a", "b", "c"); a<b<c. Alphabetical order is assumed by default. Order is relevant for adjacent, cumulative and sequential ratio.
#' @param ref_category a string indicating the reference category. Proper option for models with reference ratio.
#' @param proportional a character vector indicating the name of the variables with a proportional effect.
#' @param data a dataframe object in R, with the dependent variable as factor.
#' @param freedom_degrees an optional scalar to indicate the degrees of freedom for the Student distribution.
#' @param threshold restriction to impose on the thresholds, options are: standard or equidistant.
#' @param beta_init optional beta initialization vector.
#' @export
#' @examples
#' data(DisturbedDreams)
#' ref_log_com <- GLMcat(formula = Level ~ Age, data = DisturbedDreams,
#'     ref_category = "Very.severe",
#'     distribution = "logistic", ratio = "reference")
#'
GLMcat <- function(formula, data, ratio, distribution, proportional, categories_order, ref_category, freedom_degrees, threshold, beta_init) {
    .Call(`_GLMcat_GLMcat`, formula, data, ratio, distribution, proportional, categories_order, ref_category, freedom_degrees, threshold, beta_init)
}

#' GLMcat model predictions
#'
#' @param model_object a GLMcat model
#' @param data a data frame with the predictor variables used in the GLMcat model.
#' @param type The type of prediction to obtain. \code{"prob"} gives probabilities,
#' \code{"cum.prob"} gives cumulative probabilities and \code{"linear.predict"} gives
#' the linear predictor.
#' @rdname predict_glmcat
#' @export
#' @examples
#' data(DisturbedDreams)
#' mod1 <- GLMcat(formula = Level ~ Age,
#' data = DisturbedDreams, distribution = "logistic")
#' predict_glmcat(mod1, data = DisturbedDreams[1:5, ], type = "prob")
predict_glmcat <- function(model_object, data, type) {
    .Call(`_GLMcat_predict_glmcat`, model_object, data, type)
}

Cat_ref1 <- function(categories_order, response_categories) {
    .Call(`_GLMcat_Cat_ref1`, categories_order, response_categories)
}

