% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots.R
\name{plotCRC}
\alias{plotCRC}
\title{Plot item category response curves (CRCs)}
\usage{
plotCRC(IP, items = NULL, x.lim = 4, ThetaminDelta = TRUE, quiet = FALSE)
}
\arguments{
\item{IP}{Object of class \code{GGUM}.}

\item{items}{Vector indicating the items for which the CRCs are to be 
plotted. Default is all items.}

\item{x.lim}{Controls the limits of the x-axis. Default is -4 through +4.}

\item{ThetaminDelta}{Logical; if \code{TRUE}, plot the CRCs centered at 0, 
otherwise plot the CRCs centered at \eqn{\delta}{delta} (item's
difficulty). Default is \code{TRUE}.}

\item{quiet}{Render all plots for \code{items} at once? Default is 
\code{FALSE}.}
}
\value{
The function returns a three-dimensional array with the probabilities
  associated to each item's CRC. These are the values shown in the plot.
}
\description{
\code{plot.CRC} plots item CRCs for the GUM and the GGUM.
}
\section{Details}{
 This function plots the item category response curves
  (CRCs) for the requested items.
}

\examples{
# For GUM:
# Generate data:
gen1 <- GenData.GGUM(400, 5, 3, "GUM", seed = 139)
# Fit the GUM:
fit1 <- GUM(gen1$data, 3)
# Plot CRCs:
plotCRC(fit1, items = 1, quiet = TRUE)
\dontrun{
# For GGUM:
# Generate data:
set.seed(1); C <- sample(3:5, 10, replace = TRUE)
gen2 <- GenData.GGUM(2000, 10, C, "GGUM", seed = 156)
# Fit the GGUM:
fit2 <- GGUM(gen2$data, C)
# Plot CRCs:
plotCRC(fit2, items = 1, quiet = TRUE)
}

}
\author{
Jorge N. Tendeiro, \email{j.n.tendeiro@rug.nl}
}
