\name{g.impute}
\alias{g.impute}
\title{
function to identify invalid periods in the meta-data as generated by \link{g.getmeta}
and to impute these invalid periods with the average of similar timepoints on other
days of the measurement
}
\description{
Functions takes the output from \link{g.getmeta} and information about the study
protocol to label impute invalid time segments in the data.
}
\usage{
g.impute(M, I, strategy = 1, hrs.del.start = 0, hrs.del.end = 0, 
maxdur = 0, ndayswindow = 7,desiredtz="Europe/London", TimeSegments2Zero =c())
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{M}{
  output from \link{g.getmeta}
  }
  \item{I}{
  output from \link{g.inspectfile}
}
  \item{strategy}{
    how to deal with knowledge about study protocol. value = 1 means select data
    based on \code{hrs.del.start}, \code{hrs.del.end}, and \code{maxdur}.
    Value = 2 makes that only the data between the first midnight and the last
    midnight is used for imputation. Value = 3 only selects the most active X days
    in the files. X is specified by argument \code{ndayswindow}
  }
  \item{hrs.del.start}{
    how many HOURS after start of experiment did wearing of monitor start?
  }
  \item{hrs.del.end}{
    how many HOURS before the end of the experiment did wearing of monitor
    definitely end?
  }
  \item{maxdur}{
    How many DAYS after start of experiment did experiment
    definitely stop? (set to zero if unknown = default)
  }
  \item{ndayswindow}{
    If \code{strategy} is set to 3 then this is the size of the window as a number
    of days
  }
  \item{desiredtz}{
  see \link{g.getmeta}
  }
  \item{TimeSegments2Zero}{
  Optional data.frame to specify which time segments need to be ignored for the imputation,
  and acceleration metrics to be imputed by zeros. The data.frame is expected
  to contain two columns named windowstart and windowend, with the start- and end
  time of the time segment in POSIXlt class.
  }
  
  
}

\value{
  \item{metashort}{imputed short epoch variables}
  \item{rout}{matrix to clarify when data was imputed for each long epoch time window
  and the reason for imputation. Value = 1 indicates imputation. 
  Columns 1 = monitor non wear, column 2 = clipping, column 3 = additional nonwear,
  column 4 = protocol based exclusion and column5 = sum of column 1,2,3 and 4. }
  \item{averageday}{matrix with n columns for n metrics values and m rows for
  m short epoch time windows in an average 24 hours period}
}
\examples{
\dontrun{
  #inspect file:
  I = g.inspectfile(datafile)
  
  #autocalibration:
  C = g.calibrate(datafile) 
  
  #get meta-data:
  M = g.getmeta(datafile)
}

data(data.getmeta)
data(data.inspectfile)

#impute meta-data:
IMP = g.impute(M=data.getmeta, I=data.inspectfile)

}

\author{
  Vincent T van Hees <vincentvanhees@gmail.com>
}