% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p.GFisher.R
\name{p.GFisher}
\alias{p.GFisher}
\title{Survival function of the generalized Fisher's p-value combination statistic.}
\usage{
p.GFisher(q, df, w, M, p.type = "two", method = "HYB", nsim = NULL,
  seed = NULL)
}
\arguments{
\item{q}{- observed GFisher statistic.}

\item{df}{- vector of degrees of freedom for inverse chi-square transformation for each p-value. If all df's are equal, it can be defined by the constant.}

\item{w}{- vector of weights.}

\item{M}{- correlation matrix of the input statistics.}

\item{p.type}{- "two" = two-sided p-values, "one" = one-sided p-values.}

\item{method}{- "MR" = simulation-assisted moment ratio matching, "HYB" = moment ratio matching by quadratic approximation, "GB" = Brown's method with calculated variance. See details in the reference.}

\item{nsim}{- number of simulation used in the "MR" method, default = 5e4.}

\item{seed}{- random seed used in the "MR" method}
}
\value{
p-value of the observed GFisher statistic.
}
\description{
Survival function of the generalized Fisher's p-value combination statistic.
}
\examples{
set.seed(123)
n = 10
M = matrix(0.3, n, n) + diag(0.7, n, n)
zscore = matrix(rnorm(n),nrow=1)\%*\%chol(M)
pval = 2*(1-pnorm(abs(zscore)))
gf1 = stat.GFisher(pval, df=2, w=1)
gf2 = stat.GFisher(pval, df=1:n, w=1:n)
p.GFisher(gf1, df=2, w=1, M=M, method="HYB")
\donttest{p.GFisher(gf1, df=2, w=1, M=M, method="MR", nsim=5e4)}
p.GFisher(gf2, df=1:n, w=1:n, M=M, method="HYB")
\donttest{p.GFisher(gf2, df=1:n, w=1:n, M=M, method="MR", nsim=5e4)}
}
\references{
Hong Zhang and Zheyang Wu. "Accurate p-Value Calculation for Generalized Fisher's Combination Tests Under Dependence", <arXiv:2003.01286>.
}
