% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envelopes.r
\name{plot.combined_global_envelope}
\alias{plot.combined_global_envelope}
\title{Plot method for the class 'combined_global_envelope'}
\usage{
\method{plot}{combined_global_envelope}(
  x,
  main,
  ylim = NULL,
  xlab,
  ylab,
  coord = NULL,
  color_outside = TRUE,
  env.col = 1,
  base_size = 12,
  labels = NULL,
  add = FALSE,
  digits = 3,
  level = 1,
  ncol = 2 + 1 * (length(x) == 3),
  nticks = 5,
  legend = TRUE,
  ...
)
}
\arguments{
\item{x}{An 'combined_global_envelope' object}

\item{main}{See \code{\link{plot.default}}. A sensible default exists.}

\item{ylim}{See \code{\link{plot.default}}. A sensible default exists.}

\item{xlab}{See \code{\link{plot.default}}. A sensible default exists.}

\item{ylab}{See \code{\link{plot.default}}. A sensible default exists.}

\item{coord}{A data frame of the spatial coordinates where the data have been observed.
\code{nrow(coord)} should match the length of \code{x$r}, and the names of the columns
should be either "x", "y", "width", "height" or "xmin", "ymin", "xmax", "ymax".
Here x and y should give the (center) coordinates of the observed data,
width and height give the size of the pixel places at (x,y) (most often constants).
The xmin, ymin, xmax, ymax give an alternative way to specify the pixels where the data have
been observed, namely the corner locations of each pixel.
If coord is provided, then a two-dimensional plot is made instead of 1-dimensional default
plot.}

\item{color_outside}{Logical. Whether to color the places where the data function goes
outside the envelope. Currently red color is used. Relevant only for \code{plot_style = "basic"}.}

\item{env.col}{The color for the envelope lines (or dotplot arrows). Default 1 (black).}

\item{base_size}{Base font size, to be passed to theme style when \code{plot_style = "ggplot2"}.}

\item{labels}{A character vector of suitable length.
If \code{dotplot = TRUE} (for the level 2 test), then labels for the tests at x-axis.
Otherwise labels for the separate plots.}

\item{add}{Whether to add the plot to an existing plot (TRUE) or to draw a new plot (FALSE).
Not available for \code{plot_style = "ggplot2"}.}

\item{digits}{The number of digits used for printing the p-value or p-interval in the main,
if using the default main.}

\item{level}{1 or 2. In the case of two-step combined tests (with several test functions), two different plots are available:
1 for plotting the combined global envelopes (default and most often wanted) or
2 for plotting the second level test result.}

\item{ncol}{The maximum number of columns for the figures.
Default 2 or 3, if the length of x equals 3.
(Relates to the number of curve_sets that have been combined.)}

\item{nticks}{The number of ticks on the xaxis.}

\item{legend}{Logical. If FALSE, then the legend is removed from the "ggplot2" style plot.}

\item{...}{Additional parameters to be passed to \code{\link{plot}} or \code{\link{lines}}.}
}
\description{
This function provides plots for combined global envelopes.
Note that the argument \code{coord} is as for the single global envelopes
(see \code{\link{plot.global_envelope}}), but its dimensions should match
the dimensions of x[[i]] (for all i). That is, the plots with \code{coord}
are currently provided only for the case where the components of the object \code{x}
have the same \code{r}. This is suitable in particular for the functional ANOVA and
functional general linear models (see \code{\link{graph.fanova}}, \code{\link{graph.flm}},
\code{\link{frank.fanova}}, \code{\link{frank.flm}}) made for images.
}
\seealso{
\code{\link{central_region}}
}
