% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stepCounter.R
\name{stepCounter}
\alias{stepCounter}
\title{Step Counter}
\usage{
stepCounter(data, samplefreq = 100, smlen = 20L, AxesMethod = c("X",
  "Y", "Z", "XZ", "XY", "YZ", "XYZ"), filterorder = 4L,
  threshold = 0.01, boundaries = c(0.15, 1),
  stepmethod = c("Chebyfilter", "Butterfilter", "longrun", "none"),
  Rp = 0.5, plot.it = FALSE, Centre = TRUE, STFT = FALSE,
  verbose = FALSE, fun = c("GENEAcount", "mean", "GENEAamplitude",
  "sd", "mad", "GENEAwavelength"))
}
\arguments{
\item{data}{The data to use for calculating the steps. This should be a matrix
with columns time, x, y, z.}

\item{samplefreq}{The sampling frequency of the data, in hertz,
when calculating the step number (default 100).}

\item{smlen}{single integer number of data points used as a window
when counting zero crossing events}

\item{AxesMethod}{Select which axes to count the steps. \enumerate{
    \item 'X'
    \item 'Y' (default)
    \item 'Z'
    \item 'XY'
    \item 'XZ'
    \item 'YZ'
    \item 'XYZ'
}}

\item{filterorder}{single integer, order of the Butterworth bandpass filter,
passed to argument n of \code{\link[signal]{butter}}.}

\item{threshold}{A threshold that acts as a proxy for magnitude on the filtered xz signal for calculating steps.}

\item{boundaries}{length 2 numeric vector specifying lower and upper bounds
of Butterworth or Chebychev filter (default \code{c(0.04, 1)}),
passed to argument W of \code{\link[signal]{butter}} or \code{\link[signal]{cheby1}}.}

\item{stepmethod}{select method to use: \enumerate{
    \item 'Chebyfilter' (default)
    \item 'Butterfilter'
    \item 'longrun'
    \item 'none'
}}

\item{Rp}{the decibel level that the cheby filter takes, see \code{\link[signal]{cheby1}}.}

\item{plot.it}{single logical create plot of data and zero crossing points (default \code{FALSE}).}

\item{Centre}{If Centre set to true (default) then the step counter zeros the xz series before filtering.}

\item{STFT}{If STFT is TRUE then the Step Counter uses the STFT function to find the length of the window for each segment.}

\item{verbose}{single logical should additional progress reporting be printed at the console? (default FALSE).}

\item{fun}{character vector naming functions by which to summarize steps.
"count" is an internally implemented summarizing function that returns step count.}
}
\value{
Returns a vector with length fun.
}
\description{
Function to calculate the number and variance of the steps in the data.
}
\examples{
d1 <- matrix(c(100, 101, -0.79, -0.86,
        -0.17, -0.14, 0.53, 0.46),
    nrow = 2, ncol = 4)
stepCounter(data = d1, stepmethod = "longrun")
}
