% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeCountercyclicalProductTax.R
\name{makeCountercyclicalProductTax}
\alias{makeCountercyclicalProductTax}
\title{Make a Countercyclical Product Tax Policy Function}
\usage{
makeCountercyclicalProductTax(agent = 1, time.win = c(100, Inf), span = 50)
}
\arguments{
\item{agent}{a vector specifying the indices or names of firms to be taxed.}

\item{time.win}{the time window vector, i.e. a 2-vector specifying the start time and end time of policy implementation.}

\item{span}{a positive integer which indicates the number of periods when calculating the average output.}
}
\value{
A countercyclical product tax policy function.
}
\description{
This function returns a countercyclical product tax policy function to accelerate convergence when calculating general equilibrium.
In some cases this tax policy with variable tax rates can stabilize the economy (see Li, 2019, section 9.4.5.4) .
When a firm's output is higher than the average output in previous periods, a tax is imposed on the firm to reduce the output of the product.
Tax revenue will be used for implicit public spending.
The way of taxation is to directly deduct a part of the supply of the firm.
}
\examples{
\donttest{
ge <- gemCanonicalDynamicMacroeconomic_4_3(
  numberOfPeriods = 1000
)

ge <- gemCanonicalDynamicMacroeconomic_4_3(
  numberOfPeriods = 1000,
  policy = makeCountercyclicalProductTax(time.win = c(500, Inf))
)
}
}
\seealso{
CGE::Example9.10.policy.tax
}
