% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemInputOutputTable_easy_5_4.R
\name{gemInputOutputTable_easy_5_4}
\alias{gemInputOutputTable_easy_5_4}
\title{An Easy General Equilibrium Model based on a 5x4 Input-Output Table (see Zhang Xin, 2017, Table 8.6.1)}
\usage{
gemInputOutputTable_easy_5_4(
  IT = cbind(sector.agri = c(agri = 260, manu = 345, serv = 400, lab = 200, cap = 160),
    sector.manu = c(agri = 320, manu = 390, serv = 365, lab = 250, cap = 400),
    sector.serv = c(agri = 150, manu = 390, serv = 320, lab = 400, cap = 210), sector.hh
    = c(agri = 635, manu = 600, serv = 385, lab = 0, cap = 0)),
  supply.labor = 850,
  supply.capital = 770,
  es.agri = 0.2,
  es.manu = 0.3,
  es.serv = 0.1,
  es.VA.agri = 0.25,
  es.VA.manu = 0.5,
  es.VA.serv = 0.8
)
}
\arguments{
\item{IT}{the input and consumption part of the input-output table.}

\item{supply.labor}{the supply of labor.}

\item{supply.capital}{the supply of capital.}

\item{es.agri, es.manu, es.serv}{the elasticity of substitution between the intermediate input
and the value-added input of the agriculture sector, manufacturing sector and service sector.}

\item{es.VA.agri, es.VA.manu, es.VA.serv}{the elasticity of substitution between labor input and capital input
of the agriculture sector, manufacturing sector and service sector.}
}
\value{
A general equilibrium, which is a list with the following elements:
\itemize{
\item p - the price vector with labor as numeraire.
\item D - the demand matrix, also called the input table. Wherein the benchmark prices are used.
\item DV - the demand value matrix, also called the value input table. Wherein the current price is used.
\item SV - the supply value matrix, also called the value output table. Wherein the current price is used.
\item ... - some elements returned by the CGE::sdm function
}
}
\description{
This is a general equilibrium model based on a 5x4 input-output table (see Zhang Xin, 2017, Table 8.6.1).
}
\details{
Given a 5x4 input-output table (e.g., see Zhang Xin, 2017, Table 8.6.1), this model calculates
the corresponding general equilibrium.
This input-output table contains 3 production sectors and one household.
The household consumes products and supplies labor and capital.
}
\examples{
sector.agri <- c(260, 345, 400, 200, 160)
sector.manu <- c(320, 390, 365, 250, 400)
sector.serv <- c(150, 390, 320, 400, 210)
sector.hh <- c(635, 600, 100, 0, 0)

IT <- cbind(sector.agri, sector.manu, sector.serv, sector.hh)
rownames(IT) <- c("agri", "manu", "serv", "lab", "cap")

ge <- gemInputOutputTable_easy_5_4(IT)

####
ge <- gemInputOutputTable_easy_5_4(supply.capital = 1870)
prop.table(ge$z[1:3])
}
\references{
Zhang Xin (2017, ISBN: 9787543227637) Principles of Computable General Equilibrium Modeling and Programming (Second Edition). Shanghai: Gezhi Press. (In Chinese)
}
