% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ratio_adjust.R
\name{ratio_adjust}
\alias{ratio_adjust}
\title{Ratio Adjustment}
\usage{
ratio_adjust(
  ratio,
  coef = 0.8,
  method = c("log", "left.linear", "trunc.log", "linear")
)
}
\arguments{
\item{ratio}{a positive numeric vector.}

\item{coef}{a positive number.}

\item{method}{a character string specifying the adjustment method.}
}
\value{
A vector.
}
\description{
Adjust ratios to new values.
}
\details{
For a positive ratio and the following methods, the return values are as follows:
\itemize{
\item log : coef * log(ratio) + 1, if ratio >= 1; 1 / (coef * log(1 / ratio) + 1), if ratio < 1.
\item left.linear : 1 / (coef * (1 / ratio - 1) + 1), if ratio >= 1; 1 + coef * (ratio - 1), if ratio < 1.
\item trunc.log : max(coef * log(ratio) + 1, 0).
\item linear : coef * (ratio - 1) + 1.
}
}
\examples{
ratio_adjust(10, 0.8)
ratio_adjust(0.1, 0.8)

x <- seq(0.01, 2, 0.01)
plot(x, x, type = "l")
lines(x, ratio_adjust(x, 0.8, method = "log"), col = "red")
lines(x, ratio_adjust(x, 0.8, method = "left.linear"), col = "blue")
lines(x, ratio_adjust(x, 0.8, method = "trunc.log"), col = "green")
}
