% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/designmatrix.R
\name{designmatrix}
\alias{designmatrix}
\title{Design matrix for parameter transformation}
\usage{
designmatrix(Kj, model = "GDINA")
}
\arguments{
\item{Kj}{the number of attributes for item j}

\item{model}{the model fitted to item j; it can be "GDINA","DINA","DINO","ACDM","LLM",or "RRUM".
The default is "GDINA".}
}
\value{
a design matrix (Mj) which plays a critical role of transforming probability of success with
        delta parameters. See de la Torre (2011) for details.
}
\description{
This function calculates the design matrix \eqn{M_j} in de la Torre (2011),
which can be useful for parameter transformation between probability of success and
delta.
}
\examples{

# transform probability of success to delta
# based on saturated GDINA model
# assuming an item with 2 attributes has the following
# probability of success for 00, 10, 01 and 11
pj <- c(0.2,0.4,0.6,0.8)
Mj <- designmatrix(2)
# delta parameters can be calculated in this way:
deltaj <- solve(Mj)\%*\%pj
# for reduced CDMs, OLS or WLS may be used


}
\references{
de la Torre, J. (2011). The generalized DINA model framework. \emph{Psychometrika, 76}, 179-199.
}
