% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GDILM_SEIRS_Par_Est.R
\name{GDILM_SEIRS_Par_Est}
\alias{GDILM_SEIRS_Par_Est}
\title{GDILM SEIRS for Real Data}
\usage{
GDILM_SEIRS_Par_Est(
  data,
  adjacency_matrix,
  DimCovInf,
  DimCovSus,
  DimCovSusReInf,
  tau0,
  lambda0,
  alphaS0,
  delta0,
  alphaT0,
  InfPrd,
  IncPrd,
  NIterMC
)
}
\arguments{
\item{data}{Dataset. The dataset should exactly match the \code{data} file in the data folder, including all the columns with the same names.}

\item{adjacency_matrix}{Adjacency matrix representing the regions in the study area (0 if no connection between regions)}

\item{DimCovInf}{Dimensions of the individual infectivity covariate}

\item{DimCovSus}{Dimensions of the area-level susceptibility to initial infection covariate}

\item{DimCovSusReInf}{Dimensions of the area-level susceptibility to reinfection covariate}

\item{tau0}{Initial value for spatial precision}

\item{lambda0}{Initial value for spatial dependence}

\item{alphaS0}{Initial value for the susceptibility intercept}

\item{delta0}{Initial value for the spatial decay parameter}

\item{alphaT0}{Initial value for the infectivity intercept}

\item{InfPrd}{Infectious period that can be obtained either from the literature or by fitting an SEIRS model to the data}

\item{IncPrd}{Incubation period that can be obtained either from the literature or by fitting an SEIRS model to the data}

\item{NIterMC}{Number of MCMC iterations}
}
\value{
\code{alphaS} Estimate of alpha S

\code{BetaCovInf} Estimate of beta vector for the individual level infection covariate

\code{BetaCovSus} Estimate of beta vector for the areal susceptibility to first infection covariate

\code{BetaCovSusReInf} Estimate of beta vector for the areal susceptibility to reinfection covariate

\code{alphaT} Estimate of alpha T

\code{delta} Estimate of delta

\code{tau1} Estimate of tau

\code{lambda1} Estimate of lambda

\code{AIC} AIC of the fitted GDILM SEIRS
}
\description{
This function applies the Geographically Dependent Individual Level Model (GDILM) for infectious disease transmission, incorporating reinfection dynamics within the Susceptible-Exposed-Infectious-Recovered-Susceptible (SEIRS) framework, to real data. It employs a likelihood based Monte Carlo Expectation Conditional Maximization (MCECM) algorithm for parameter estimation and AIC calculation. This function requires two dataframes, named \code{data} and \code{adjacency_matrix}, along with the necessary parameters. Detailed information on the structure of these two datasets is provided in the package.
}
\examples{
\donttest{
data(data)
data(adjacency_matrix)
GDILM_SEIRS_Par_Est(data,adjacency_matrix,2,2,2,0.8, 0.5, -1, 2.5, 0, 2, 3, 20)
}

}
