% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riskmean.R
\name{riskmean}
\alias{riskmean}
\alias{print.riskmean}
\alias{plot.riskmean}
\title{Geographical detectors: risk means in risk detector.}
\usage{
riskmean(formula, data = NULL)
\method{print}{riskmean}(x, ...)
\method{plot}{riskmean}(x, ...)
}
\arguments{
\item{formula}{a formula of response and explanatory variables}

\item{data}{a data.frame includes response and explanatory variables}

\item{x}{a list of risk mean values}

\item{...}{ignore}
}
\description{
Function for calculating risk means within intervals and visualization.
}
\examples{
rm1 <- riskmean(NDVIchange ~ Climatezone + Mining, data = ndvi_40)
rm1
plot(rm1)
\donttest{
data <- ndvi_40[,1:3]
rm2 <- riskmean(NDVIchange ~ ., data = data)
rm2
}

}
