% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_chromatogram.R
\name{draw_chromatogram}
\alias{draw_chromatogram}
\title{Visualise peak lists as a pseudo-chromatogram}
\usage{
draw_chromatogram(
  data = NULL,
  rt_col_name = NULL,
  conc_col_name = NULL,
  width = 0.1,
  step = NULL,
  sep = "\\t",
  breaks = NULL,
  rt_limits = NULL,
  samples = NULL,
  show_num = FALSE,
  show_rt = FALSE,
  plot = TRUE,
  shape = c("gaussian", "stick"),
  legend.position = "bottom"
)
}
\arguments{
\item{data}{The input data can be either a GCalignR input file or an GCalign object. See \code{\link{align_chromatograms}} for details on both.}

\item{rt_col_name}{A character giving the name of the column containing the retention times. The decimal separator needs to be a point.}

\item{conc_col_name}{Character, denoting a variable used to scale the peak height (e.g., peak area or peak height.)}

\item{width}{Numeric value giving the standard deviation of Gaussian peaks. Decrease this value to separate overlapping peaks within samples. Default is 0.01.}

\item{step}{character allowing to visualise different steps of the alignment when a GCalign object is used. By default the aligned data is shown.}

\item{sep}{The field separator character. The default is tab separated (\code{sep = '\\t'}).
See the "sep" argument in \code{\link[utils]{read.table}} for details.}

\item{breaks}{A numeric vector giving the breakpoints between ticks on the x axis.}

\item{rt_limits}{A numeric vector of length two giving min and max values or retention times to plot.}

\item{samples}{A character vector of sample names to draw chromatograms of a subset.}

\item{show_num}{Boolean indicating whether sample numbers are drawn on top of each peak.}

\item{show_rt}{Boolean indicating whether peak retention times are drawn on top of each peak.}

\item{plot}{Boolean indicating if the plot is printed.}

\item{shape}{A character determining the shape of peaks. Peaks are approximated as "gaussian" by default. Alternatively, peaks can be visualised as "sticks".}

\item{legend.position}{See \code{\link[ggplot2]{theme}} for options of legend positions.}
}
\value{
A list containing the data frame created for plotting and the ggplot object. See \code{\link[ggplot2]{ggplot}}.
}
\description{
Creates a graphical representation of one or multiple peak lists in the form of a pseudo- chromatogram. Peaks are represented by Gaussian distributions centred at the peak retention time. The peak height is arbitrary and does not reflect any measured peak intensity.
}
\details{
Peaks from the are depicted as Gaussian distributions. If the data is an "GCalign" object that was processed with \code{\link{align_chromatograms}}, chromatograms can be drawn for the dataset prior to alignment (\strong{"input"}), after correcting linear drift (\strong{"shifted"}) or after the complete alignment was conducted (\strong{"aligned"}). In the latter case, retention times refer to the mean retention time of a homologous peaks scored among samples and do not reflect any between-sample variation anymore. Depending on the range of retention times and the distance among substances the peak width can be adjusted to enable a better visual separation of peaks by changing the value of parameter \code{width}. Note, homologous peaks (= exactly matching retention time) will overlap completely and only the last sample plotted will be visible. Hence, the number of samples can be printed on top of each peak. The function returns a list containing the ggplot object along with the internally used data frame to allow for maximum control in adapting the plot (see examples section in this document).
}
\examples{
## load data
path <- (system.file("extdata", "simulated_peak_data.txt", package = "GCalignR"))
## run with defaults
x <- draw_chromatogram(data = path, rt_col_name = "rt")
## Customise and split samples in panels
x <- draw_chromatogram(data = path, rt_col_name = "rt", samples = c("A2","A4"),
 plot = FALSE, show_num = FALSE)
x[["ggplot"]] + ggplot2::facet_wrap(~ sample, nrow = 2)
## plot without numbers
x <- draw_chromatogram(data = path, show_num = FALSE, rt_col_name = "rt")
}
\author{
Meinolf Ottensmann (meinolf.ottensmann@web.de) & Martin Stoffel (martin.adam.stoffel@gmail.com)
}
