% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cpp_logistic_gaga}
\alias{cpp_logistic_gaga}
\title{Fit a logistic model via the Global Adaptive Generative Adjustment algorithm using cpp}
\usage{
cpp_logistic_gaga(
  X,
  y,
  s_alpha,
  s_itrNum,
  s_thresh,
  s_flag,
  s_lamda_0,
  s_fdiag,
  s_subItrNum
)
}
\arguments{
\item{X}{Input matrix, of dimension nobs*nvars; each row is an observation.
If the intercept term needs to be considered in the estimation process, then the first column of \code{X} must be all 1s.}

\item{y}{should be either a factor with two levels.}

\item{s_alpha}{Hyperparameter. The suggested value for alpha is 1 or 2.
When the collinearity of the load matrix is serious, the hyperparameters can be selected larger, such as 5.}

\item{s_itrNum}{The number of iteration steps. In general, 20 steps are enough.
If the condition number of \code{X} is large, it is recommended to greatly increase the
number of iteration steps.}

\item{s_thresh}{Convergence threshold for beta Change, if \code{max(abs(beta-beta_old))<threshold}, return.}

\item{s_flag}{It identifies whether to make model selection. The default is \code{TRUE}.}

\item{s_lamda_0}{The initial value of the regularization parameter for ridge regression.
The running result of the algorithm is not sensitive to this value.}

\item{s_fdiag}{It identifies whether to use diag Approximation to speed up the algorithm.}

\item{s_subItrNum}{Maximum number of steps for subprocess iterations.}
}
\value{
Coefficient vector.
}
\description{
Fit a logistic model via the Global Adaptive Generative Adjustment algorithm using cpp
}
