% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gp_plot.R
\name{gp_plot}
\alias{gp_plot}
\title{Plot 1D Gaussian Process Model}
\usage{
gp_plot(model, inputs, plot_data = FALSE)
}
\arguments{
\item{model}{A GP model of class \code{km} (see \code{\link[DiceKriging]{km-class}}).}

\item{inputs}{An vector of values at which to evaluate the GP model.}

\item{plot_data}{Plot data used to fit the GP as well?}
}
\value{
A list of GP predictions and uncertainties used to generate the figure.
}
\description{
Plots univariate Gaussian process (GP) models with 95\% credible bands. For extremely simply visualizations.
}
\examples{
x  <- matrix(seq(-1,1,0.3),ncol=1)
y  <- x^2 
gp <- gp_fit(x,
             y,
             options=list(formula=~1, 
             kernel = "matern5_2", 
             optimizer = "gen", 
             nuggetUse = FALSE))
gp_plot(gp$km.model,seq(-1.5,1.5,0.1)) 
}
