% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bastos_ohagan_09.R
\name{bo09_toy}
\alias{bo09_toy}
\title{Two-Input Toy Model from Bastos and O'Hagan (2009)}
\usage{
bo09_toy(x)
}
\arguments{
\item{x}{A vector of length 2.}
}
\value{
A scalar.
}
\description{
A toy model for the demonstration of Gaussian process validation plots and statistics. It is a product of a rational function in x[1] and an exponential function in x[2]. The function is smoother in x[2] than x[1]. The function's domain is the unit square.
}
\examples{
print(bo09_toy(c(0.5,0.25)))

n <- 100
a <- seq(0,1,length.out = n)
x <- expand.grid(a,a)
z <- matrix(apply(x,1,bo09_toy),n,n)
graphics::contour(a,a,z, xlab = expression(x[1]), ylab = expression(x[2]))

}
\references{
Bastos, L. S., & O'Hagan, A. (2009). Diagnostics for gaussian process emulators. Technometrics, 51(4), 425–438, <doi:10.1198/TECH.2009.08019>.
}
