% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/methods-min_max.R
\docType{methods}
\name{maximum}
\alias{maximum}
\alias{maximum,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}
\title{Maximum of fuzzy nubmers}
\usage{
\S4method{maximum}{PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber}(e1, e2)
}
\arguments{
\item{e1}{a PiecewiseLinearFuzzyNumber}

\item{e2}{a PiecewiseLinearFuzzyNumber}
}
\value{
Returns a PiecewiseLinearFuzzyNumber representing maximal
value of the inputs.
}
\description{
Determines maximum fuzzy number based on two inputs.
}
\details{
The resulting
PiecewiseLinearFuzzyNumber is only an approximation of the result
it might not be very precise for small number of knots (see examples).
}
\examples{
# example with low number of knots, showing the approximate nature
# of the result
x = as.PiecewiseLinearFuzzyNumber(TriangularFuzzyNumber(-4.8, -3 , -1.5))
y = as.PiecewiseLinearFuzzyNumber(TriangularFuzzyNumber(-5.5, -2.5, -1.1))
maxFN = maximum(x,y)
min = min(alphacut(x,0)[1],alphacut(y,0)[1])
max = max(alphacut(x,0)[2],alphacut(y,0)[2])
plot(x, col="red", xlim=c(min,max))
plot(y, col="blue", add=TRUE)
plot(maxFN, col="green", add=TRUE)

# example with high number of knots, that does not suffer
# from the approximate nature of the result
x = as.PiecewiseLinearFuzzyNumber(TriangularFuzzyNumber(-4.8, -3 , -1.5), knot.n = 9)
y = as.PiecewiseLinearFuzzyNumber(TriangularFuzzyNumber(-5.5, -2.5, -1.1), knot.n = 9)
maxFN = maximum(x,y)
min = min(alphacut(x,0)[1],alphacut(y,0)[1])
max = max(alphacut(x,0)[2],alphacut(y,0)[2])
plot(x, col="red", xlim=c(min,max))
plot(y, col="blue", add=TRUE)
plot(maxFN, col="green", add=TRUE)
}
\references{
KAUFMANN, A., GUPTA, M. M. (1985) Introduction to Fuzzy Arithmetic.
 New York : Van Nostrand Reinhold Company. ISBN 044230079.
}
\seealso{
Other PiecewiseLinearFuzzyNumber-method: \code{\link{*,PiecewiseLinearFuzzyNumber,FuzzyNumber-method}},
  \code{\link{*,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{*,PiecewiseLinearFuzzyNumber,numeric-method}},
  \code{\link{*,TrapezoidalFuzzyNumber,numeric-method}},
  \code{\link{*,numeric,FuzzyNumber-method}},
  \code{\link{+,PiecewiseLinearFuzzyNumber,FuzzyNumber-method}},
  \code{\link{+,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{+,PiecewiseLinearFuzzyNumber,numeric-method}},
  \code{\link{+,TrapezoidalFuzzyNumber,TrapezoidalFuzzyNumber-method}},
  \code{\link{+,numeric,FuzzyNumber-method}},
  \code{\link{-,FuzzyNumber,ANY-method}},
  \code{\link{-,PiecewiseLinearFuzzyNumber,FuzzyNumber-method}},
  \code{\link{-,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{-,PiecewiseLinearFuzzyNumber,numeric-method}},
  \code{\link{-,TrapezoidalFuzzyNumber,TrapezoidalFuzzyNumber-method}},
  \code{\link{-,numeric,FuzzyNumber-method}},
  \code{\link{/,PiecewiseLinearFuzzyNumber,FuzzyNumber-method}},
  \code{\link{/,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{/,PiecewiseLinearFuzzyNumber,numeric-method}},
  \code{\link{Arithmetic}};
  \code{\link{PiecewiseLinearFuzzyNumber-class}};
  \code{\link{PiecewiseLinearFuzzyNumber}};
  \code{\link{^,PiecewiseLinearFuzzyNumber,numeric-method}};
  \code{\link{alphaInterval}},
  \code{\link{alphaInterval,FuzzyNumber-method}},
  \code{\link{alphaInterval,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{alphaInterval,PowerFuzzyNumber-method}},
  \code{\link{alphaInterval,TrapezoidalFuzzyNumber-method}};
  \code{\link{arctan2}},
  \code{\link{arctan2,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}};
  \code{\link{as.PiecewiseLinearFuzzyNumber}},
  \code{\link{as.PiecewiseLinearFuzzyNumber,FuzzyNumber-method}},
  \code{\link{as.PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{as.PiecewiseLinearFuzzyNumber,TrapezoidalFuzzyNumber-method}},
  \code{\link{as.PiecewiseLinearFuzzyNumber,numeric-method}};
  \code{\link{as.PowerFuzzyNumber}},
  \code{\link{as.PowerFuzzyNumber,FuzzyNumber-method}},
  \code{\link{as.PowerFuzzyNumber,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{as.PowerFuzzyNumber,PowerFuzzyNumber-method}},
  \code{\link{as.PowerFuzzyNumber,TrapezoidalFuzzyNumber-method}},
  \code{\link{as.PowerFuzzyNumber,numeric-method}};
  \code{\link{as.TrapezoidalFuzzyNumber}},
  \code{\link{as.TrapezoidalFuzzyNumber,FuzzyNumber-method}},
  \code{\link{as.TrapezoidalFuzzyNumber,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{as.TrapezoidalFuzzyNumber,PowerFuzzyNumber-method}},
  \code{\link{as.TrapezoidalFuzzyNumber,TrapezoidalFuzzyNumber-method}},
  \code{\link{as.TrapezoidalFuzzyNumber,numeric-method}};
  \code{\link{as.character}},
  \code{\link{as.character,FuzzyNumber-method}},
  \code{\link{as.character,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{as.character,PowerFuzzyNumber-method}},
  \code{\link{as.character,TrapezoidalFuzzyNumber-method}};
  \code{\link{expectedInterval}},
  \code{\link{expectedInterval,FuzzyNumber-method}},
  \code{\link{expectedInterval,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{expectedInterval,PowerFuzzyNumber-method}},
  \code{\link{expectedInterval,TrapezoidalFuzzyNumber-method}};
  \code{\link{fapply}},
  \code{\link{fapply,PiecewiseLinearFuzzyNumber,function-method}};
  \code{\link{minimum}},
  \code{\link{minimum,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}};
  \code{\link{necessityExceedance}},
  \code{\link{necessityExceedance,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}};
  \code{\link{necessityStrictExceedance}},
  \code{\link{necessityStrictExceedance,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}};
  \code{\link{necessityStrictUndervaluation}},
  \code{\link{necessityStrictUndervaluation,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}};
  \code{\link{necessityUndervaluation}},
  \code{\link{necessityUndervaluation,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}};
  \code{\link{plot}},
  \code{\link{plot,DiscontinuousFuzzyNumber,missing-method}},
  \code{\link{plot,FuzzyNumber,missing-method}},
  \code{\link{plot,PiecewiseLinearFuzzyNumber,missing-method}},
  \code{\link{plot,TrapezoidalFuzzyNumber,missing-method}};
  \code{\link{possibilityExceedance}},
  \code{\link{possibilityExceedance,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}};
  \code{\link{possibilityStrictExceedance}},
  \code{\link{possibilityStrictExceedance,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}};
  \code{\link{possibilityStrictUndervaluation}},
  \code{\link{possibilityStrictUndervaluation,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}};
  \code{\link{possibilityUndervaluation}},
  \code{\link{possibilityUndervaluation,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}}

Other min_max-operators: \code{\link{minimum}},
  \code{\link{minimum,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}}
}

