% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frechetpc.R
\name{predict.Frechforest}
\alias{predict.Frechforest}
\title{Frechet random forests prediction function}
\usage{
\method{predict}{Frechforest}(object, X, time, id, timeScale = 0.1, ...)
}
\arguments{
\item{object}{[list]: a list of the randomized Frechet tree composing the Frechet random forest.}

\item{X}{[matrix]: a data frame or a matrix of trajectories predictors.}

\item{time}{[vector]: time measurements of the new trajectories to predict.}

\item{id}{[vector]: identifier, one for each trajectory to attribute each measurement of \code{X} to one of the trajectories.}

\item{timeScale}{[numeric]: allow to modify the time scale, increasing or decreasing the cost of the horizontal shift. If timeScale is very big, then the Frechet mean tends to the Euclidean distance. If timeScale is very small, then it tends to the Dynamic Time Warping.}

\item{...}{: optional parameters to be passed to the low level function.}
}
\description{
Given a Frechet tree and new input trajectories predictors \code{X}, this function allows to predict output trajectories \code{Y} associated with the new \code{X} given a Frechet random forest
}
\examples{
\dontrun{
set.seed(10)
data <- DataGenCurves(30)
FRF <- Frechforest(data$X,data$Y, data$id,data$time, ntree=40,ncores=2, toPlot="none")
pred <- predict(FRF, data$X, data$time, data$id)
}
}
