% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EW_ForLion_MLM_Optimal.R
\name{EW_ForLion_MLM_Optimal}
\alias{EW_ForLion_MLM_Optimal}
\title{EW ForLion function for multinomial logit models}
\usage{
EW_ForLion_MLM_Optimal(
  J,
  n.factor,
  factor.level,
  hfunc,
  h.prime,
  bvec_matrix,
  link = "continuation",
  EW_Fi.func = EW_Fi_MLM_func,
  delta = 1e-05,
  epsilon = 1e-12,
  reltol = 1e-05,
  rel.diff = 0,
  maxit = 100,
  random = FALSE,
  nram = 3,
  rowmax = NULL,
  Xini = NULL,
  random.initial = FALSE,
  nram.initial = 3,
  optim_grad = FALSE
)
}
\arguments{
\item{J}{number of response levels in the multinomial logit model}

\item{n.factor}{vector of numbers of distinct levels, "0" indicates continuous factors, "0"s always come first, "2" or above indicates discrete factor, "1" is not allowed}

\item{factor.level}{list of distinct levels, (min, max) for continuous factor, continuous factors first, should be the same order as n.factor}

\item{hfunc}{function for obtaining model matrix h(y) for given design point y, y has to follow the same order as n.factor}

\item{h.prime}{function to obtain dX/dx}

\item{bvec_matrix}{the matrix of the bootstrap parameter values of beta}

\item{link}{link function, default "continuation", other choices "baseline", "cumulative", and "adjacent"}

\item{EW_Fi.func}{function to calculate row-wise Expectation of Fisher information Fi, default is EW_Fi_MLM_func}

\item{delta}{tuning parameter, the generated design pints distance threshold, || x_i(0) - x_j(0) || >= delta, default 1e-5}

\item{epsilon}{determining f.det > 0 numerically, f.det <= epsilon will be considered as f.det <= 0, default 1e-12}

\item{reltol}{the relative convergence tolerance, default value 1e-5}

\item{rel.diff}{points with distance less than that will be merged, default value 0}

\item{maxit}{the maximum number of iterations, default value 100}

\item{random}{TRUE or FALSE, if TRUE then the function will run EW lift-one with additional "nram" number of random approximate allocation, default to be FALSE}

\item{nram}{when random == TRUE, the function will run EW lift-one nram number of initial proportion p00, default is 3}

\item{rowmax}{maximum number of points in the initial design, default NULL indicates no restriction}

\item{Xini}{initial list of design points, default NULL will generate random initial design points}

\item{random.initial}{TRUE or FALSE, if TRUE then the function will run EW ForLion with additional "nram.initial" number of random initial design points, default FALSE}

\item{nram.initial}{when random.initial == TRUE, the function will run EW ForLion algorithm with nram.initial number of initial design points Xini, default is 3}

\item{optim_grad}{TRUE or FALSE, default is FALSE, whether to use the analytical gradient function or numerical gradient for searching optimal new design point}
}
\value{
m the number of design points

x.factor matrix of experimental factors with rows indicating design point

p the reported EW D-optimal approximate allocation

det the determinant of the maximum Expectation of Fisher information

convergence TRUE or FALSE, whether converge

min.diff the minimum Euclidean distance between design points

x.close  pair of design points with minimum distance

itmax iteration of the algorithm
}
\description{
EW ForLion function for multinomial logit models
}
\examples{
J=3
p=5
hfunc.temp = function(y){
matrix(data=c(1,y,y*y,0,0,0,0,0,1,y,0,0,0,0,0), nrow=3, ncol=5, byrow=TRUE)
} #hfunc is a 3*5 matrix, transfer x design matrix to model matrix for emergence of flies example

hprime.temp = function(y){
matrix(data=c(0, 1, 2*y, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0), nrow=3, ncol=5, byrow=TRUE)
}

link.temp = "continuation"
n.factor.temp = c(0)  # 1 continuous factor no discrete factor in EW ForLion
factor.level.temp = list(c(80,200)) #boundary for continuous parameter in Forlion
bvec_bootstrap<-matrix(c(-0.2401, -1.9292, -2.7851, -1.614,-1.162,
                         -0.0535, -0.0274, -0.0096,-0.0291, -0.04,
                          0.0004,  0.0003,  0.0002,  0.0003,  0.1,
                         -9.2154, -9.7576, -9.6818, -8.5139, -8.56),nrow=4,byrow=TRUE)
EW_ForLion_MLM_Optimal(J=J, n.factor=n.factor.temp, factor.level=factor.level.temp,
         hfunc=hfunc.temp,h.prime=h.prime.temp, bvec_matrix=bvec_bootstrap,rel.diff=1,
         link=link.temp, optim_grad=FALSE)

}
