% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hasPeriodic.R
\name{hasPeriodic}
\alias{hasPeriodic}
\title{Does object include a periodic B-spline term?}
\usage{
hasPeriodic(x)
}
\arguments{
\item{x}{An object of class \code{\link[=fitFluMoDL]{FluMoDL}}}
}
\value{
\code{TRUE} if the model includes a periodic term, \code{FALSE} if it does not.
}
\description{
This method checks whether a 'FluMoDL' object includes a
periodic B-spline term in its parametrization or not. 
By default FluMoDL objects are created with a periodic term, 
unless argument \code{periodic} in \code{\link{fitFluMoDL}} is set to \code{FALSE}
}
\examples{
data(greece) # Use example surveillance data from Greece
m <- with(greece, fitFluMoDL(deaths = daily$deaths,
    temp = daily$temp, dates = daily$date,
    proxyH1 = weekly$ILI * weekly$ppH1,
    proxyH3 = weekly$ILI * weekly$ppH3,
    proxyB = weekly$ILI * weekly$ppB,
    yearweek = weekly$yearweek))
hasPeriodic(m)   # Returns TRUE

}
